/**
* Copyright (c) Huawei Technologies Co., Ltd. 2020-2022. All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at

* http://www.apache.org/licenses/LICENSE-2.0

* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.

* File sample_process.h
* Description: handle acl resource
*/
#ifndef CAR_PARAMS_H
#define CAR_PARAMS_H
#pragma once

#include <iostream>
#include <mutex>
#include <memory>
#include <vector>
#include <unistd.h>
#include <sys/timeb.h>
#include <time.h>
#include "AclLiteType.h"
#include "AclLiteModel.h"
#include "AclLiteImageProc.h"
#include "opencv2/opencv.hpp"
#include "opencv2/imgproc/types_c.h"
#include "opencv2/highgui/highgui.hpp"
#define RGBF32_CHAN_SIZE(width, height) ((width) * (height) * 4)

namespace {
const int MSG_APP_START = 1;
const int MSG_READ_FRAME = 2;
const int MSG_DETECT_PREPROC_DATA = 3;
const int MSG_DETECT_INFER_OUTPUT = 4;
const int MSG_DETECT_POSTPROC_DATA = 5;
const int MSG_CLASSIFY_PREPROC_DATA = 6;
const int MSG_CLASSIFY_INFER_OUTPUT = 7;
const int MSG_ENCODE_FINISH = 8;
const int MSG_PRESENT_AGENT_DISPLAY = 9;
const int MSG_RTSP_DISPLAY = 10;
const int MSG_APP_EXIT = 11;
const int MSG_MQTT_SEND = 12;

const std::string kInferName = "inference";
const std::string khelmetInferName = "helmetinference";
const std::string kDetectPreName = "detectPre";
const std::string kDetectPostName = "detectPost";
const std::string kClassifyPreName = "classifyPre";
const std::string kClassifyPostName = "classifyPost";
const std::string kPresentAgentDisplayName = "PresentAgentDisplay";
const std::string kRtspDisplayName = "rtspDisplay";
}

struct Rectangle {
    cv::Point lt;  // left top
    cv::Point rb;  // right bottom
};
struct BBoxstr {
    Rect rect;
    float score = 0.0;
    uint32_t cls;
    std::string text;
};
struct CarInfo {
    ImageData cropedImgs;  // cropped car image from original image
    ImageData resizedImgs;  //resized image for classify inference
    Rectangle rectangle;  // recognize rectangle
    std::string detect_result;  // yolo detect output
    std::string carColor_result;
};
struct ObjInfo {
    ImageData cropedImgs;  // cropped car image from original image
    ImageData resizedImgs;  //resized image for classify inference
    Rectangle rectangle;  // recognize rectangle
    std::string detect_result;  // yolo detect output
    std::string classify_result;
};
struct OnlyDetectNameInfo {
    std::string kInferName;
    std::string kDetectPreName;
    std::string kDetectPostName;
    std::string kRtspUrl;
    std::string kMqttName;


};

struct Detect2clsNameInfo {
    std::string kInferName;
    std::string kDetectPreName;
    std::string kDetectPostName;
    std::string kClassifyPreName;
    std::string kClassifyPostName;
    std::string kMqttName;
    std::string kRtspUrl;

};

struct ModelInfo {
    int modelInputWidth = 640;
    int modelInputHeight = 448;
    int clsifyInputWidth = 224;
    int clsifyInputHeight = 224;
    int totalBox = 17640;
    int classnum = 80;  // cropped car image from original image
    float nmsThresh = 0.45;
    float conf = 0.3;
    std::vector<int> activateLabel = {0};
    std::vector<std::string> Label = { "person", "bicycle", "car", "motorbike",
                                                          "aeroplane", "bus", "train", "truck", "boat",
                                                          "traffic light", "fire hydrant", "stop sign", "parking meter",
                                                          "bench", "bird", "cat", "dog", "horse",
                                                          "sheep", "cow", "elephant", "bear", "zebra",
                                                          "giraffe", "backpack", "umbrella", "handbag", "tie",
                                                          "suitcase", "frisbee", "skis", "snowboard", "sports ball",
                                                          "kite", "baseball bat", "baseball glove", "skateboard", "surfboard",
                                                          "tennis racket", "bottle", "wine glass", "cup",
                                                          "fork", "knife", "spoon", "bowl", "banana",
                                                          "apple", "sandwich", "orange", "broccoli", "carrot",
                                                          "hot dog", "pizza", "donut", "cake", "chair",
                                                          "sofa", "potted plant", "bed", "dining table", "toilet",
                                                          "TV monitor", "laptop", "mouse", "remote", "keyboard",
                                                          "cell phone", "microwave", "oven", "toaster", "sink",
                                                          "refrigerator", "book", "clock", "vase", "scissors",
                                                          "teddy bear", "hair drier", "toothbrush" };
    std::vector<std::string> clsLabel = {"black", "blue", "brown",
                                         "green", "pink", "red",
                                         "silver", "white", "yellow"};
};

//struct HelmetInfo : public ModelInfo{
//    int modelInputWidth = 640;
//    int modelInputHeight = 448;
//    int totalBox = 17640;

//    int classnum = 3;  // cropped car image from original image
//    float nmsThresh = 0.45;
//    float conf = 0.5;
//    std::vector<std::string> Label = { "person", "hat", "nohat",};
//};

namespace INSTANCENAME{
    const int CAR_COLOR_INFERENCE_INSTANCE = 0;
    const int HELMET_INFERENCE_INSTANCE = 1;
    const int FIRESMOKE_INFERENCE_INSTANCE = 2;
    const int SMOKER_SLEEP_INFERENCE_INSTANCE = 3;
    const int COCO_PERSON_INFERENCE_INSTANCE = 4;
    const int YANGCHEN_INFERENCE_INSTANCE = 5;
    const int MASK_INFERENCE_INSTANCE = 6;
}

struct ObjDetectDataMsg {
    int inferThreadId;
    int detectPostThreadId;
    int classifyPreThreadId;
    int classifyPostThreadId;
    int presentAgentDisplayThreadId;
    int rtspDisplayThreadId;
    int mqttSendThreadId;
    uint32_t deviceId;
    uint32_t channelId;  // record msg belongs to which rtsp/video channel
    int isLastFrame;  // whether the last frame of rtsp/video of this channel has been decoded
    int frameNum;  // record frameID in rtsp/video of this channel
    ImageData imageFrame;  // original image (NV12)
    ImageData resizedFrame;  // image after detect preprocess
    cv::Mat frame;  // original image (BGR) needed by postprocess
    std::vector<InferenceOutput> detectInferData;  // yolo detect output
    std::vector<ObjInfo> objInfo;  // save car images's info detected in frame, and save classify output
    int flag;  // whether car is detected in frame
    std::vector<InferenceOutput> classifyInferData;  // classify output
};

#endif