import request from '@/utils/request'
// 目标系统管理列表及查询
export function getList(data) {
  return request({
    url: '/servicesysManager/manager/list',
    method: 'post',
    data
  })
}

// 新增
export function addFile(data) {
  return request({
    url: '/servicesysManager/manager',
    method: 'post',
    data: data
  })
}
// 修改
export function updateFile(data) {
  return request({
    url: '/servicesysManager/manager',
    method: 'put',
    data: data
  })
}

// 删除
export function delFile(id) {
  return request({
    url: '/servicesysManager/manager/' + id,
    method: 'delete'
  })
}

// AES随机生成秘钥
export function getAESKey() {
  return request({
    url: '/AesEncryptUtil/getKey',
    method: 'get'
  })
}
// AES随机生成秘钥
export function createKeys() {
  return request({
    url: '/RSAUtils/createKeys',
    method: 'get'
  })
}
