import request from '@/utils/request'

// 查询用户组列表
export function listGroup (query) {
    return request({
      url: '/system/group/list',
      method: 'get',
      params: query
    })
  }
// 删除用户组
export function delGroup (groupIds) {
    return request({
      url: '/system/group/' + groupIds,
      method: 'delete'
    })
  }
  // 新增用户组
export function addGroup (data) {
    return request({
      url: '/system/group',
      method: 'post',
      data: data
    })
  }
  // 修改保存用户组
export function updateGroup (data) {
    return request({
      url: '/system/group',
      method: 'put',
      data: data
    })
  }
  // 查询部门下拉列表（排除节点）
export function listGroupExcludeChild (groupId) {
    return request({
      url: '/system/group/list/exclude/' + groupId,
      method: 'get'
    })
  }
  // 查询用户组详细（回显用）
export function getGroup (groupId) {
    return request({
      url: '/system/group/' + groupId,
      method: 'get'
    })
  }
