// pages/uploadcard/uploadcard.js
import Toast from '../../vantPackage/toast/toast';
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    fileList: {
      positive: [], //正面照
      emblem: [], //国徽面
      face: [], //上半身人脸
      diploma: [] //毕业证
    },
  },
  onClickLeft() {
    wx.navigateTo({
      url: `/pages/document/subsign/subsign?id=${app.courseId}`,
    })
  },
  beforeRead(event) {
    const {
      file,
      callback
    } = event.detail;
    let imageType = file.url.split('.');
    if ((imageType[imageType.length - 1] !== 'jpg') && (imageType[imageType.length - 1] !== 'jpeg') && (imageType[imageType.length - 1] !== 'png')) {
      Toast.fail({
        message: '上传失败，请上传图片',
        forbidClick: true,
      });
      callback(false);
    } else if (file.size > 1000000) {
      Toast.fail({
        message: '图片大小超过限制，请重新上传',
        forbidClick: true,
      });
      callback(false);
    } else {
      callback(true);
    };
  },
  //身份证正面照
  afterReadPositive(event) {
    const {
      file
    } = event.detail;
    // 当设置 mutiple 为 true 时, file 为数组格式，否则为对象格式
    app.colorUISdk.requestImg({
      url: 'infostudent/common/upload',
      method: 'POST',
      filePath: file.url,
      header: {
        "Content-Type": "multipart/form-data",
      },
      formData: {
        file,
        filePath: "C:/ftp_wl/uploadFile/"
      }
    }).then((res) => {
      let result = JSON.parse(res);
      if (result.code == 0) {
        const {
          positive = []
        } = this.data.fileList;
        positive.push({
          ...file,
          url: res.result,
          path: result.path
        });
        this.setData({
          ["fileList.positive"]: positive
        });
      } else {
        Toast.fail('上传失败');
      }
    })
  },
  deleteImgPositive(file) {
    this.setData({
      ["fileList.positive"]: []
    });
  },
  //身份证反面照
  afterReadEmblem(event) {
    const {
      file
    } = event.detail;
    app.colorUISdk.requestImg({
      url: 'infostudent/common/upload',
      method: 'POST',
      filePath: file.url,
      header: {
        "Content-Type": "multipart/form-data",
      },
      formData: {
        file,
        filePath: "D:/uploadFile/img"
      }
    }).then((res) => {
      let result = JSON.parse(res);
      if (result.code == 0) {
        const {
          emblem = []
        } = this.data.fileList;
        emblem.push({
          ...file,
          url: res.result,
          path: result.path
        });
        this.setData({
          ["fileList.emblem"]: emblem
        });
      } else {
        Toast.fail('上传失败');
      }
    })
  },
  deleteImgEmblem(file) {
    this.setData({
      ["fileList.emblem"]: []
    });
  },
  //上半身照片
  afterReadFace(event) {
    const {
      file
    } = event.detail;
    app.colorUISdk.requestImg({
      url: 'infostudent/common/upload',
      method: 'POST',
      filePath: file.url,
      header: {
        "Content-Type": "multipart/form-data",
      },
      formData: {
        file,
        filePath: "D:/uploadFile/img"
      }
    }).then((res) => {
      let result = JSON.parse(res);
      if (result.code == 0) {
        const {
          face = []
        } = this.data.fileList;
        face.push({
          ...file,
          url: res.result,
          path: result.path
        });
        this.setData({
          ["fileList.face"]: face
        });
      } else {
        Toast.fail('上传失败');
      }
    })
  },
  deleteImgReadFace(file) {
    this.setData({
      ["fileList.face"]: []
    });
  },
  //毕业证书
  afterRead(event) {
    const {
      file
    } = event.detail;
    app.colorUISdk.requestImg({
      url: 'infostudent/common/upload',
      method: 'POST',
      filePath: file.url,
      header: {
        "Content-Type": "multipart/form-data",
      },
      formData: {
        file,
        filePath: "D:/uploadFile/img"
      }
    }).then((res) => {
      let result = JSON.parse(res);
      if (result.code == 0) {
        const {
          diploma = []
        } = this.data.fileList;
        diploma.push({
          ...file,
          url: res.result,
          path: result.path
        });
        this.setData({
          ["fileList.diploma"]: diploma
        });
      } else {
        Toast.fail('上传失败');
      }
    })
  },
  deleteImgRead(file) {
    this.setData({
      ["fileList.diploma"]: []
    });
  },
  sendMeans() {
    if(this.data.fileList.positive.length == 0){
      Toast.fail("请上传身份证正面照");
      return;
    };
    // if(this.data.fileList.emblem.length == 0){
    //   Toast.fail("请上传身份证反面照");
    //   return;
    // };
    // if(this.data.fileList.face.length == 0){
    //   Toast.fail("请上传上半身照");
    //   return;
    // };
    // if(this.data.fileList.diploma.length == 0){
    //   Toast.fail("请上传毕业证书或户口本现实学历");
    //   return;
    // };
    const toast = Toast.loading({
      message: '订单生成中,请稍候。。。',
      forbidClick: true,
      loadingType: 'spinner',
      duration:0
    });
    app.colorUISdk.request({
      url: "infostudent/studentSave",
      data: {
        courseId: app.information.id, //课程id
        name: app.information.username, //学生姓名  
        sex: app.information.gender, //性别
        card: app.information.card,
        education: app.information.studyhigh, //文化程度
        phone: app.information.phone,
        company: app.information.company,
        jobCategory: app.information.homework, //作业类别
        qualificationsType: app.information.zige,
        trainType: app.information.peixun,
        remark: app.information.beizhu,
        sfzzmimgUrl: this.data.fileList.positive[0].path,
        // sfzbmimgUrl:this.data.fileList.emblem[0].path,
        // sbsimgUrl:this.data.fileList.face[0].path,
        // byzimgUrl:this.data.fileList.diploma[0].path
      }
    }).then((res) => {
      // console.log(res)
      if (res.code == 0) {
        toast.message ="订单创建成功，请稍候。。。"
        let openid = wx.getStorageSync('openid');
        let studentId = res.studentId; 
        app.colorUISdk.request({
          url: `wx/pay_one?openid=${openid}&price=${parseInt(app.information.price * 100)}&studentId=${studentId}`,
          //&phone=${app.information.phone}&price=${parseInt(app.information.price * 100)}&courseId=${app.information.id}
          method: 'POST',
          data:{}
        }).then(({
          prepay_info,
          sign_info,
          code
        }) => {
          // console.log(prepay_info);
          // console.log(sign_info);
          // console.log(code);
          if(code == 0){
            Toast.clear();
            if (prepay_info !== undefined && sign_info !== undefined) {
              wx.requestPayment({
                "timeStamp": sign_info.timeStamp,
                "nonceStr": sign_info.nonceStr,
                "package": sign_info.package,
                "signType": "RSA",
                "paySign": sign_info.paySign,
                "success": function (res) {
                    //支付成功生成学生信息
                    Toast.success('支付成功');
                    setTimeout(()=>{
                      wx.switchTab({
                        url: '/pages/home/home',
                      })
                    },1500)
                },
                "fail": function (res) {
                  //删除前一个
                  app.colorUISdk.request({
                    url: "infostudent/delete",
                    data: {
                    ids:studentId
                    }   
                  }).then((data) => {
                    if (data && data.code === 0) {
                      Toast.fail({
                        message: '支付失败'
                      });
                    } else {
                      Toast.fail({
                        message: data.message
                      });
                    };
               //     console.log(data);
                  })
                },
                // "complete":function(res){
                //     console.log(res);
                // }
              })
            } else {
              //删除前一个
              app.colorUISdk.request({
                url: "infostudent/delete",
                data: {
                  ids:studentId
                }
              }).then((data) => {
                if (data && data.code === 0) {
                  Toast.fail('生成订单失败，请稍候再试');
                } else {
                  Toast.fail({
                    message: data.message
                  });
                };
              })
            }
          }else{
           Toast.clear();
           Toast.fail('服务器异常，请稍候');
          }
          


        }).catch(err => {
          console.log(err)
        })
      }

    }).catch((err) => {
      Toast('请求失败');
      console.log(err);
    })
    //   app.colorUISdk.request({
    //     url:`wx/gt?code=${e.detail.code}`,  //上传课程价格接口
    //     method: 'POST',
    //     data:{
    //       price:price, 
    //       courseName:''
    //     }
    //   }).then(({data})=> {
    //     //创建订单成功，返回给我一些必要参数，然后调起微信支付
    //     Toast.clear();
    //     //唤起微信支付
    //     let time = (new Date().getTime().toString()).substring(0,10)
    //     wx.requestPayment({
    //       appId:'wx95ac219beca2f34f',
    //       timeStamp:time,
    //       nonceStr:this.randomWord(true,parseInt((Math.random() * 20)),parseInt((Math.random() * 30))), //生成长度为20~30的随机字符串
    //       package:'prepay_id=wx201410272009395522657a690389285100', //等待回传结果
    //       signType:"RSA",
    //       paySign:'', //后台加密计算好给我
    //       fail:function(){
    //         Toast.fail('您已取消支付')
    //       },
    //     })
    //     if(data.errcode == 0){
    //         let random =  this.randomWord(false, 43);
    //     }
    //     this.setData({courseData: res.data.records})
    // }).catch(err=>{
    //     console.log(err)
    // })
  },
  randomWord(randomFlag, min, max) {
    let str = "",
      range = min,
      arr = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
    // 随机产生
    if (randomFlag) {
      range = Math.round(Math.random() * (max - min)) + min;
    }
    for (var i = 0; i < range; i++) {
      let pos = Math.round(Math.random() * (arr.length - 1));
      str += arr[pos];
    }
    return str;
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(app.information);
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})