// pages/order/order.js
const app = getApp();
import Toast from '../../vantPackage/toast/toast';
Page({

  /**
   * 页面的初始数据
   */
  data: {
    value:'',
    list:[],
    isEmpty:false
  },
  onSearch(){},
  onCancel(){},
  orderDetail(e){
   // console.log(e);
    app.orderDetail = e.target.dataset.item;
    wx.navigateTo({
      url: '/pages/document/orderdetail/orderdetail',
    })
  },
  // onClick(event) {
  //   wx.showToast({
  //     title: `点击标签 ${event.detail.name}`,
  //     icon: 'none',
  //   });
  // },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
    
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    let openid = wx.getStorageSync('openid');
    let phone = wx.getStorageSync('phone');
    if(openid == '' && phone == ''){
        wx.showToast({
          title: '您还未登录，即将跳转登录',
          icon: 'none'
        })
        setTimeout(()=>{
            wx.switchTab({
              url: '/pages/home/home',
            })
        },2000)
    }else{
      app.colorUISdk.request({
        url:`infostudentorder/infoOrderByOpenId?openId=${openid}`,
        method: 'GET',
        data: {}
    }).then((res)=>{
      if(res.code == 0){
        if(res.infoStudentOrderEntity.length > 0){
           //处理价格&&时间
        let list = res.infoStudentOrderEntity.map((a)=>{
          a.cost = parseInt(a.cost * 100) / 10000;
          a.payerTotal =  parseInt(a.payerTotal * 100) / 10000;
          a.successTime = (a.successTime.split("+")[0]).replace(/T/ig," ");
          return a;
        });
        this.setData({
          list:list
        });
        }else{
          this.setData({
            isEmpty:true
          })
        }
       
      }else{
        Toast.fail('请求异常')
      }
      console.log(res);
    })
    }
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})