//图片上传请求
const requestImg = (promise, loading = false, config) => {
  return new Promise( (resolve, reject) => {
      if (['produce','dev','host'].includes(config.env)) {
          if (loading) {
              wx.showLoading({
                  title:'请求中',
                  mask: true
              })
          }
          wx.uploadFile({
            url: config.api[config.env].url + promise.url, 
            header: promise.header || config.api.header,
            filePath: promise.filePath || config.api.filePath,
            name: 'file',
            timeout:30000,
            formData:promise.formData,
            success: res => {
              if (res.statusCode === 200) {
                  resolve(res.data);
              } else {
                  wx.showToast({
                      title: res.msg,
                      icon: 'none',
                      duration: 2000
                  });
                  reject(res.msg)
              }
          },
          fail: err => {
              wx.showToast({title: "上传失败",icon: 'none'});
              reject(err)
          },
          complete() {
              if (loading) {
                  wx.hideLoading()
              }
          }
          });
      } else {
          wx.showToast({title: "环境异常",icon: 'none'});
          reject({msg: "环境异常"})
      }
  });
};

module.exports = {
    requestImg:requestImg
}
