// pages/document/subsign/subsign.js
import Toast from '../../../vantPackage/toast/toast';
const app = getApp();
Page({

    /**
     * 页面的初始数据
     */
    data: {
        username:'', //姓名
        card:'', 
        phone:'',
        company:'',
        beizhu:'',
        isSignupShow:true,
        isShow:false,
        isShowStudy:false,
        isShowHomework:false,
        isShowZige:false,
        isShowPeixun:false,
        fromDate:{
            id:'',
            username:'', //姓名
            gender:'',  //性别
            card:'',  //身份证号
            studyhigh:'',  //文化程度
            phone:'', //手机号
            company:'',  //单位名称
            homework:'', //作业类别
            zige:'', //资格类型
            peixun:'', //培训类型
            beizhu:'', //备注
            price:''  //价格
        },
        popup:{
            genderText:'点击选择性别',
            studyText:'点击选择您的文化程度',
            homeworkText:'点击选择作业类别',
            zigeTypeText:'点击选择资格类型',
            peixunTypeText:'点击选择培训类型',
        },
        columns: [
            { text: '男', type:0 },
            { text: '女' ,type:1},
        ],
        // columnsStudy:[
        //     {text:'初中',index:1},
        //     {text:'高中',index:2},
        //     {text:'中专',index:3},
        //     {text:'专科',index:4},
        //     {text:'本科',index:5},
        //     {text:'研究生及以上',index:6},
        // ],
        columnsStudy:[
            '初中',
            '高中',
            '中专',
            '专科',
            '本科','研究生及以上'
        ],
        columnsHomework:[],
        // columnsHomework:[
        //     {text:'电工作业',index:1},
        //     {text:'焊接与热切割作业',index:2},
        //     {text:'高处作业',index:3},
        //     {text:'制冷与空调作业',index:4},
        //     {text:'金属与非金属矿山作业',index:5},
        //     {text:'危险化学品作业',index:6},
        // ],
        columnsZige:[],
        columnsPeixun:['新办','复审','换证']
        // columnsPeixun:[
        //     {text:'新办',index:1},
        //     {text:'复审',index:2},
        //     {text:'换证',index:3},
        // ]
        
    },
    onDisplay(){
        this.setData({isShow:true})
    },
    onDisplayStudy(){
        this.setData({isShowStudy:true})
    },
    onDisplayHomework(){
        this.setData({isShowHomework:true})
    },
    onDisplayZigeType(){
        this.setData({isShowZige:true})
    },
    onDisplayPeixunType(){
        this.setData({isShowPeixun:true})
    },
    onClose() {
        this.setData({ isShow: false });
    },
    onCloseStudy(){
        this.setData({isShowStudy:false})
    },
    onCloseHomework(){
        this.setData({isShowHomework:false})
    },
    onCloseZige(){
        this.setData({isShowZige:false})
    },
    onClosePeixun(){
        this.setData({isShowPeixun:false})
    },
    onConfirm(event){
        const { picker, value, index } = event.detail;
        this.setData({["fromDate.gender"]:value.type,["popup.genderText"]:value.text,isShow:false})
    },
    onConfirmStudy(event){
        const { picker, value, index } = event.detail;
        this.setData({["fromDate.studyhigh"]:value,["popup.studyText"]:value,isShowStudy:false})
    },

    onConfirmHomework(event){
        const { picker, value, index } = event.detail;
        console.log(event.detail);
        //根据选中状态，请求下面列表，动态生成列表项
        app.colorUISdk.request({
            url:'dictionary/listByPar3',
            method: 'GET',
            data: {
                parentKey:value.constantKey
            }
        }).then(res=> {
            console.log(res);
           if(res.code == 0){
            let col =  res.dictionary.map((a)=>{
                return a.fieldKey;
            });
            this.setData({
                columnsZige:col
            })
           }
        }).catch(err=>{
            console.log(err)
        })
        this.setData({
            ["fromDate.homework"]:value.text,["popup.homeworkText"]:value.text,
            isShowHomework:false,     
        }
        )
    },
    onConfirmPeixun(event){
        const { picker, value, index } = event.detail;
        this.setData({["fromDate.peixun"]:value,["popup.peixunTypeText"]:value,isShowPeixun:false})
    },
    onConfirmZige(event){
        const { picker, value, index } = event.detail;
        this.setData({["fromDate.zige"]:value,["popup.zigeTypeText"]:value,isShowZige:false})
    },
    nextCard(){
        //bug问题 重新赋值
        this.setData({
            ["fromDate.username"]:this.data.username,
            ["fromDate.card"]:this.data.card,
            ["fromDate.phone"]:this.data.phone,
            ["fromDate.company"]:this.data.company,
            ["fromDate.beizhu"]:this.data.beizhu
        });
        let params = this.data.fromDate;
        let gender = '';
        if(params.gender !== ''){
            gender = this.data.fromDate.gender == 0 ? '男' :'女'
        }
        let reg = /^[1-9]\d{5}(?:18|19|20)\d{2}(?:0[1-9]|10|11|12)(?:0[1-9]|[1-2]\d|30|31)\d{3}[\dXx]$/;
        let phonereg = /^(?:(?:\+|00)86)?1\d{10}$/
        if(params.username == ''){
            Toast('姓名不能为空');
            return;
        }else if(gender == ''){
            Toast('请选择您的性别');
            return;
        }else if(!(reg.test(params.card))){
            Toast('身份证号不正确');
            return;
        }else if(!(phonereg.test(params.phone))){
            Toast('手机号格式不正确');
            return;
        }else if(params.homework == ''){
            Toast('请选择作业类别');
            return;
        }else if(params.zige == ''){
            Toast('请选择资格类型');
            return;
        }else if(params.peixun == ''){
            Toast('请选择培训类型');
            return;
        }
         app.information = this.data.fromDate;
        wx.navigateTo({
          url: '/pages/uploadcard/uploadcard',
        })
    },
    /**
     * 生命周期函数--监听页面加载
     */
    onLoad: function (options) {
        // let price = 0;
        // if(options.price == null || options.price == undefined){
        //     price = 
        // }
        let phone = app.phone == '' ? wx.getStorageSync('phone') : app.phone
        this.setData({
            ["fromDate.price"]:options.price,
            phone:phone,
            ["fromDate.phone"]:phone,
            ["fromDate.id"]:options.id
        });
         //获取课程类型，动态生成列表
         app.colorUISdk.request({
            url:'dictionary/listByPar2',
            method: 'GET',
            data: {
                courseId:options.id
            }
        }).then(res=> {
            console.log(res);
            if(res.code == 0){
              let col =  res.dictionary.map((a)=>{
                  return {text:a.fieldKey,constantKey:a.constantKey}
              });
              this.setData({
                columnsHomework:col
              });
              console.log(this.data.columnsHomework)
            }
          //  this.setData({courseData: res.data.records})
        }).catch(err=>{
            console.log(err)
        })
    },

    /**
     * 生命周期函数--监听页面初次渲染完成
     */
    onReady: function () {
       
    },

    /**
     * 生命周期函数--监听页面显示
     */
    onShow: function () {
        //有一个不为空说明已经有数据就回显数据
        if(app.information.username != undefined){
            this.isSignupShow = false;
            this.setData({
                fromDate:app.information,
                username:app.information.username,
                card:app.information.card, 
                phone:app.information.phone,
                company:app.information.company,
                beizhu:app.information.beizhu,
                ["popup.genderText"]:app.information.gender == "0" ? '男':'女',
                ["popup.studyText"]:app.information.studyhigh == '' ? '点击选择文化程度' : app.information.studyhigh,
                ["popup.homeworkText"]:app.information.homework == '' ? '点击选择作业类别':app.information.homework,
                ["popup.zigeTypeText"]:app.information.zige == '' ? '点击选择资格类型' : app.information.zige,
                ["popup.peixunTypeText"]:app.information.peixun == '' ? '点击选择培训类型' : app.information.peixun,
                ["fromDate.price"]:app.information.price,
            });
        }
    },
    onClickLeft(){
        let pages = getCurrentPages();
        let prevPage = pages[pages.length - 2];
        if(prevPage.route == "pages/uploadcard/uploadcard"){
            wx.navigateBack({
                delta: 3,
              })
        }else{
            wx.navigateBack({
                delta: 1,
              })
        }
        
    },

    /**
     * 生命周期函数--监听页面隐藏
     */
    onHide: function () {

    },

    /**
     * 生命周期函数--监听页面卸载
     */
    onUnload: function () {

    },

    /**
     * 页面相关事件处理函数--监听用户下拉动作
     */
    onPullDownRefresh: function () {

    },

    /**
     * 页面上拉触底事件的处理函数
     */
    onReachBottom: function () {

    },

    /**
     * 用户点击右上角分享
     */
    onShareAppMessage: function () {

    }
})