// pages/uploadcard/uploadcard.js
import Toast from '../../vantPackage/toast/toast';
const app = getApp();
Page({

    /**
     * 页面的初始数据
     */
    data: {
        fileList:{
          positive:[], //正面照
          emblem:[],  //国徽面
          face:[], //上半身人脸
          diploma:[]  //毕业证
        },
    },
    onClickLeft(){
        wx.navigateTo({
          url: '/pages/document/subsign/subsign',
        })
    },
    beforeRead(event){
      const { file, callback } = event.detail;
      let imageType = file.url.split('.');
      if((imageType[imageType.length-1] !== 'jpg') && (imageType[imageType.length-1] !== 'jpeg') && (imageType[imageType.length-1] !== 'png')){
        Toast.fail({
          message: '上传失败，请上传图片',
          forbidClick: true,
        });
        callback(false);
      }else if(file.size > 1000000){
        Toast.fail({
          message: '图片大小超过限制，请重新上传',
          forbidClick: true,
        });
        callback(false);
      }else{
        callback(true);
      };
    },
    afterReadPositive(event){
      const { file } = event.detail;
      // 当设置 mutiple 为 true 时, file 为数组格式，否则为对象格式
      wx.uploadFile({
        url: 'https://example.weixin.qq.com/upload', // 仅为示例，非真实的接口地址
        filePath: file.url,
        name: 'file',
        timeout:30000,
        formData: { user: 'test' },
        success(res) {
          const { positive = [] } = this.data.fileList;
          positive.push({ ...file, url: res.data });
          this.setData({["fileList.positive"]:positive});
        },
        fail(){
          Toast.fail({
            message: '上传失败，请重新上传',
            forbidClick: true,
          });
        }
      });
    },
    afterReadEmblem(event){
      const { file } = event.detail;
      // 当设置 mutiple 为 true 时, file 为数组格式，否则为对象格式
      wx.uploadFile({
        url: 'https://example.weixin.qq.com/upload', // 仅为示例，非真实的接口地址
        filePath: file.url,
        name: 'file',
        formData: { user: 'test' },
        success(res) {
          const { emblem = [] } = this.data.fileList;
          emblem.push({ ...file, url: res.data });
          this.setData({["fileList.emblem"]:emblem});
        },
        fail(){
          Toast.fail({
            message: '上传失败，请重新上传',
            forbidClick: true,
          });
        }
      });
    },
    afterReadFace(event){
      const { file } = event.detail;
      // 当设置 mutiple 为 true 时, file 为数组格式，否则为对象格式
      wx.uploadFile({
        url: 'https://example.weixin.qq.com/upload', // 仅为示例，非真实的接口地址
        filePath: file.url,
        name: 'file',
        formData: { user: 'test' },
        success(res) {
          const { face = [] } = this.data.fileList;
          face.push({ ...file, url: res.data });
          this.setData({["fileList.face"]:face});
        },
        fail(){
          Toast.fail({
            message: '上传失败，请重新上传',
            forbidClick: true,
          });
        }
      });
    },
    afterRead(event) {
        const { file } = event.detail;
        // 当设置 mutiple 为 true 时, file 为数组格式，否则为对象格式
        wx.uploadFile({
          url: 'https://example.weixin.qq.com/upload', // 仅为示例，非真实的接口地址
          filePath: file.url,
          name: 'file',
          formData: { user: 'test' },
          success(res) {
            // 上传完成需要更新 fileList
            const { diploma = [] } = this.data.fileList;
            diploma.push({ ...file, url: res.data });
            this.setData({ ["fileList.diploma"]:diploma});
          },
          fail(){
            Toast.fail({
              message: '上传失败，请重新上传',
              forbidClick: true,
            });
          }
        });
    },
    /**
     * 生命周期函数--监听页面加载
     */
    onLoad: function (options) {
      console.log(app.information);
    },

    /**
     * 生命周期函数--监听页面初次渲染完成
     */
    onReady: function () {

    },

    /**
     * 生命周期函数--监听页面显示
     */
    onShow: function () {

    },

    /**
     * 生命周期函数--监听页面隐藏
     */
    onHide: function () {

    },

    /**
     * 生命周期函数--监听页面卸载
     */
    onUnload: function () {

    },

    /**
     * 页面相关事件处理函数--监听用户下拉动作
     */
    onPullDownRefresh: function () {

    },

    /**
     * 页面上拉触底事件的处理函数
     */
    onReachBottom: function () {

    },

    /**
     * 用户点击右上角分享
     */
    onShareAppMessage: function () {

    }
})