package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.domain.dto.*;
import com.github.yulichang.base.MPJBaseService;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 固有风险清单库Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface IRiskPlanInherentListService extends MPJBaseService<RiskPlanInherentList>
{

    /**
     * 查询固有风险清单库
     *
     * @param id 固有风险清单库主键
     * @return 固有风险清单库
     */
    public RiskPlanInherentList selectRiskPlanInherentListById(Long id);

    /**
     * 查询固有风险清单库列表
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 固有风险清单库集合
     */
    public List<RiskPlanInherentList> selectRiskPlanInherentListList(RiskPlanInherentList riskPlanInherentList);

    /**
     * 新增固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    public int insertRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList);

    /**
     * 修改固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    public int updateRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList);

    /**
     * 批量删除固有风险清单库
     *
     * @param ids 需要删除的固有风险清单库主键集合
     * @return 结果
     */
    public int deleteRiskPlanInherentListByIds(Long[] ids);

    /**
     * 删除固有风险清单库信息
     *
     * @param id 固有风险清单库主键
     * @return 结果
     */
    public int deleteRiskPlanInherentListById(Long id);

    List<RiskPlanAppInherentListDto> getInherentListByPlanId(Long projectId, Long buildingId, Long floorId, Long roomId);

    Boolean saveRiskInherentListSaveDto(RiskInherentListSaveDto saveDto);

    RiskPlanAppInherentListDetailsDto getRiskPlanAppInherentListDetailsDtoByInherentId(Long inherentId);

    List<RiskPlanAppExistingListDto> getExistingListByInherentId(Long inherentId);

    RiskNotificationExportWordDto getRiskNotificationExportWordDto(Long inherentId);

    void exportPlanInherentList(HttpServletResponse response,List<RiskInherentListExportDto> dtos) throws IOException;

    List<RiskInherentListExportDto> getPlanInherentListByPlanId(Long planId);
}
