package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.RiskPlan;
import com.censoft.censoftrongtong.domain.dto.*;
import com.github.yulichang.base.MPJBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 风险计划Mapper接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface RiskPlanMapper extends MPJBaseMapper<RiskPlan>
{
    /**
     * 查询风险计划
     * 
     * @param id 风险计划主键
     * @return 风险计划
     */
    public RiskPlan selectRiskPlanById(Long id);

    /**
     * 查询风险计划列表
     * 
     * @param riskPlan 风险计划
     * @return 风险计划集合
     */
    public List<RiskPlanAppTaskDetailsDto> selectRiskPlanList(RiskPlan riskPlan);

    /**
     * 新增风险计划
     * 
     * @param riskPlan 风险计划
     * @return 结果
     */
    public int insertRiskPlan(RiskPlan riskPlan);

    /**
     * 修改风险计划
     * 
     * @param riskPlan 风险计划
     * @return 结果
     */
    public int updateRiskPlan(RiskPlan riskPlan);

    /**
     * 删除风险计划
     * 
     * @param id 风险计划主键
     * @return 结果
     */
    public int deleteRiskPlanById(Long id);

    /**
     * 批量删除风险计划
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteRiskPlanByIds(Long[] ids);

    List<RiskPlanAppListDto> getRiskPlanAppListDtoList(@Param("statusStringList") List<String> statusStringList
            , @Param("createUserId") Long createUserId, @Param("leaderUserId") Long leaderUserId, @Param("workUserId") Long workUserId,@Param("name") String name);

    RiskPlanAppDetailsDto getRiskPlanAppDetailsDtoByPlanId(@Param("planId") Long planId);

    RiskPlanAppTaskDetailsDto getRiskPlanAppTaskDetailsDtoByPlanId(@Param("planId") Long planId);

    List<RiskPlanAppRiskBuildingListDto> getRiskBuildingListDtoByPlanId(@Param("planId") Long planId
            ,@Param("buildingId") Long buildingId);

    List<RiskPlanAppApproveListDto> getApproveListDtoByPlanId(@Param("planId") Long planId);

    List<RiskPlanAppListDto> getRiskPlanAppListDtoListByApproveUser(@Param("userId") Long userId
            ,@Param("status") String status,@Param("result") String result);

    List<RiskPlanAppListDto> getRiskPlanAppListDtoListByCreateUserDeptId(@Param("deptId") Long deptId,@Param("name") String name);
}
