package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.LedgerRoom;
import com.github.yulichang.base.MPJBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 基础数据-楼层Mapper接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface LedgerRoomMapper extends MPJBaseMapper<LedgerRoom>
{
    /**
     * 查询基础数据-房间列表
     *
     * @param ledgerRoom 基础数据-房间
     * @return 基础数据-房间集合
     */
    /**
     * 查询基础数据-楼层列表
     *
     * @param ledgerRoom 基础数据-楼层
     * @return 基础数据-楼层集合
     */
    public List<LedgerRoom> selectLedgerRoomList(LedgerRoom ledgerRoom);

    String getLevelColorByRoomId(@Param("roomId") Long roomId);

    void deleteRoomByRoomIds(@Param("targetRoomIds") List<Long> targetRoomIds);
}
