package com.censoft.censoftrongtong.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.RiskPlan;
import com.censoft.censoftrongtong.service.IRiskPlanService;
import com.ruoyi.common.constant.HttpStatus;
import com.ruoyi.common.core.page.PageDomain;
import com.ruoyi.common.core.page.TableSupport;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.service.IRiskPlanInherentListService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 固有风险信息Controller
 *
 * @author ruoyi
 * @date 2023-07-20
 */
@RestController
@RequestMapping("/system/risk/inherent")
public class RiskPlanInherentListController extends BaseController
{
    @Autowired
    private IRiskPlanInherentListService riskPlanInherentListService;
    @Autowired
    private IRiskPlanService riskPlanService;

    /**
     * 查询固有风险信息列表
     */
    @PreAuthorize("@ss.hasPermi('system:inherent:list')")
    @GetMapping("/list")
    public TableDataInfo list(RiskPlanInherentList riskPlanInherentList)
    {
        startPage();
        List<RiskPlanInherentList> list = riskPlanInherentListService.selectRiskPlanInherentListList(riskPlanInherentList);
        return getDataTable(list);
    }



    /**
     * 导出固有风险信息列表
     */
    @PreAuthorize("@ss.hasPermi('system:inherent:export')")
    @Log(title = "固有风险信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, RiskPlanInherentList riskPlanInherentList)
    {
        List<RiskPlanInherentList> list = riskPlanInherentListService.selectRiskPlanInherentListList(riskPlanInherentList);
        ExcelUtil<RiskPlanInherentList> util = new ExcelUtil<RiskPlanInherentList>(RiskPlanInherentList.class);
        util.exportExcel(response, list, "固有风险信息数据");
    }

    /**
     * 获取固有风险信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:inherent:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(riskPlanInherentListService.selectRiskPlanInherentListById(id));
    }

    /**
     * 新增固有风险信息
     */
    @PreAuthorize("@ss.hasPermi('system:inherent:add')")
    @Log(title = "固有风险信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RiskPlanInherentList riskPlanInherentList)
    {
        return toAjax(riskPlanInherentListService.insertRiskPlanInherentList(riskPlanInherentList));
    }

    /**
     * 修改固有风险信息
     */
    @PreAuthorize("@ss.hasPermi('system:inherent:edit')")
    @Log(title = "固有风险信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RiskPlanInherentList riskPlanInherentList)
    {
        return toAjax(riskPlanInherentListService.updateRiskPlanInherentList(riskPlanInherentList));
    }

    /**
     * 删除固有风险信息
     */
    @PreAuthorize("@ss.hasPermi('system:inherent:remove')")
    @Log(title = "固有风险信息", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(riskPlanInherentListService.deleteRiskPlanInherentListByIds(ids));
    }
}
