package com.censoft.censoftrongtong.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.domain.dto.RiskExistingListSaveDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppExistingListDetailsDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppExistingListDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppInherentListDetailsDto;
import com.censoft.censoftrongtong.mapper.RiskPlanExistingListMapper;
import com.censoft.censoftrongtong.service.IRiskPlanExistingListService;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.service.ISysUploadFileService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 现有风险清单库Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanExistingListServiceImpl
        extends ServiceImpl<RiskPlanExistingListMapper, RiskPlanExistingList>
        implements IRiskPlanExistingListService {
    @Autowired
    private RiskPlanExistingListMapper riskPlanExistingListMapper;

    @Resource
    private ISysUploadFileService uploadFileService;

    @Override
    public RiskPlanAppExistingListDetailsDto getRiskPlanAppExistingListDetailsDtoByExistingId(Long existingId) {
        RiskPlanAppExistingListDetailsDto dto =  riskPlanExistingListMapper.getRiskPlanAppExistingListDetailsDtoByExistingId(existingId);

        //风险源照片
        if (!StrUtil.hasEmpty(dto.getPictureFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getPictureFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setPictureFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //工程技术措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresProjectFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresProjectFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresProjectFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //管理措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresAdministrationFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresAdministrationFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresAdministrationFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //应急处置措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresEmergencyFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresEmergencyFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresEmergencyFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        return dto;
    }

    @Override
    public Boolean saveRiskExistingListSaveDto(RiskExistingListSaveDto saveDto) {
        RiskPlanExistingList existingList = new RiskPlanExistingList();
        BeanUtils.copyProperties(saveDto, existingList);
        existingList.setMeasuresDeptId(saveDto.getMeasuresDeptLongId());
        existingList.setMeasuresUserId(saveDto.getMeasuresUserLongId());
        existingList.setCreateTime(new Date());
        return saveOrUpdate(existingList);
    }
}
