package com.censoft.censoftrongtong.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.framework.web.domain.server.SysFile;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author 周昊
 * @desc ...
 * @date 2023-06-27 14:45:45
 */
@Data
public class RiskPlanAppDetailsDto {
    /** id */
    private Long id;

    /**
     * 项目业态
     */

    private String projectBusiness;

    /**
     * 经营状态
     */

    private String businessStatus;

    /**
     * 是否为物业
     */

    private Boolean propertyManagement;


    /** 发起人员id */
    private Long createUserId;

    /** 发起人员名称 */
    private String createUserName;

    /** 项目负责人id */
    private Long leaderUserId;

    /** 项目负责人名称 */
    private String leaderUserName;

    /** 状态 */
    private String status;

    /** 发起时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    /** 任务流程节点 */
    private String statusKey;

    /** 任务详情 */
    private RiskPlanAppTaskDetailsDto detailsDto;

    /** 风险清单 */
    private List<RiskPlanAppInherentListDto> inherentListDtos;

    /** 风险清单 */
    private List<RiskPlanAppRiskBuildingListDto> riskBuildingListDtos;

    /** 风险清单 */
    private List<RiskPlanAppApproveListDto> approveListDtos;

    /** 风险评估报告 */
    private List<SysFile> files;
}
