package com.censoft.censoftrongtong.domain.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

/**
 * 基础数据-楼层对象 ledger_floor
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
public class LedgerRoomDto {

    private Long id;

    /** 所属区域id */
    private Long deptId;

    /** 所属区域名称 */
    @Excel(name = "所属区域",sort = 1)
    private String deptName;

    /** 项目id */
    private Long projectId;

    /** 项目名称 */
    @Excel(name = "项目名称",sort = 2)
    private String projectName;

    /** 楼宇id */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buildingId;

    /** 楼宇名称 */
    @Excel(name = "楼宇名称",sort = 3)
    private String buildingName;

    /** 楼层id */
    private Long floorId;

    /** 楼层名称 */
    @Excel(name = "楼层名称",sort = 4)
    private String floorName;

    /** 房间名称 */
    @Excel(name = "房间名称",sort = 5)
    private String name;

    /** 房屋类型 */
    @Excel(name = "房屋类型",sort = 6)
    private String roomType;

    /** 状态（0正常 1停用） */
    @Excel(name = "状态", readConverterExp = "0=正常,1=停用",sort = 7)
    private String status;
}
