package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.TableName;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

/**
 * 固有风险清单库对象 risk_inherent_list
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
@TableName("risk_inherent_list")
public class RiskInherentListVO extends BaseEntity
{



    /**
     * 风险源名称
     */

    private String name;

    /**
     * 风险点类型
     */

    private String pointType;

    /**
     * 是否为特种设备
     */

    private Boolean specialEquipment;

    /**
     * 安全警示标志
     */

    private String safetyWarningSigns;

    /**
     * 风险因素
     */

    private String factor;

    /**
     * 准事故类型
     */

    private String type;

    /**
     * 工程技术措施
     */

    private String measuresProject;

    /**
     * 应采取的管理措施
     */

    private String measuresAdministration;

    /**
     * 应急措施
     */

    private String measuresEmergency;

    /**
     * 是否存在重大危险源
     */

    private Boolean majorHazardSource;

    /**
     * 危险源名称
     */

    private String hazardSourceName;

    /**
     * 重大危险源描述
     */

    private String majorHazardSourceDescription;

    /**
     * 参考依据
     */

    private String referenceBasis;

    /**
     * 删除标志（0代表存在 1代表删除）
     */

    private String delFlag;
}
