package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;

/**
 * 基础数据-楼层对象 ledger_floor
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
public class LedgerFloor extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /** 楼宇id */

    @JsonSerialize(using = ToStringSerializer.class)
    private Long buildingId;

    /** 楼层名称 */
    @Excel(name = "楼层名称",sort = 2)
    private String name;

    /** 楼层属性 */
    @Excel(name = "楼层属性",sort = 3)
    private String type;

    /** 房间数量 */
    private Long roomNumber;

    /** 状态（0正常 1停用） */
    @Excel(name = "状态", readConverterExp = "0=正常,1=停用",sort = 4)
    private String status;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    /**
     * 楼栋名称
     */
    @TableField(exist = false)
    @Excel(name = "楼宇名称",sort = 1)
    private String buildingName;

    /** 组织机构id */
    @TableField(exist = false)
    private Long deptId;


}
