package com.ruoyi.system.mapper;

import com.ruoyi.system.domain.SysUploadFile;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 文件Mapper接口
 * 
 * @author hzhou
 * @date 2022-08-18
 */
public interface SysUploadFileMapper
{
    /**
     * 查询文件
     * 
     * @param fileId 文件主键
     * @return 文件
     */
    public SysUploadFile selectSysFileByFileId(Long fileId);

    /**
     * 查询文件列表
     * 
     * @param sysUploadFile 文件
     * @return 文件集合
     */
    public List<SysUploadFile> selectSysFileList(SysUploadFile sysUploadFile);

    /**
     * 新增文件
     * 
     * @param sysUploadFile 文件
     * @return 结果
     */
    public int insertSysFile(SysUploadFile sysUploadFile);

    /**
     * 修改文件
     * 
     * @param sysUploadFile 文件
     * @return 结果
     */
    public int updateSysFile(SysUploadFile sysUploadFile);

    /**
     * 删除文件
     * 
     * @param fileId 文件主键
     * @return 结果
     */
    public int deleteSysFileByFileId(Long fileId);

    /**
     * 批量删除文件
     * 
     * @param fileIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSysFileByFileIds(Long[] fileIds);

    public List<SysUploadFile> selectSysFileByFileIds(@Param("fileIds") List<Long> fileIds);
}
