package com.ruoyi.system.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.system.domain.Websites;
import com.ruoyi.system.service.IWebsitesService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 网站管理Controller
 * 
 * @author ruoyi
 * @date 2023-06-27
 */
@RestController
@RequestMapping("/system/websites")
public class WebsitesController extends BaseController
{
    @Autowired
    private IWebsitesService websitesService;

    /**
     * 查询网站管理列表
     */
    @PreAuthorize("@ss.hasPermi('system:websites:list')")
    @GetMapping("/list")
    public TableDataInfo list(Websites websites)
    {
        startPage();
        List<Websites> list = websitesService.selectWebsitesList(websites);
        return getDataTable(list);
    }

    /**
     * 导出网站管理列表
     */
    @PreAuthorize("@ss.hasPermi('system:websites:export')")
    @Log(title = "网站管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Websites websites)
    {
        List<Websites> list = websitesService.selectWebsitesList(websites);
        ExcelUtil<Websites> util = new ExcelUtil<Websites>(Websites.class);
        util.exportExcel(response, list, "网站管理数据");
    }

    /**
     * 获取网站管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:websites:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(websitesService.selectWebsitesById(id));
    }

    /**
     * 新增网站管理
     */
    @PreAuthorize("@ss.hasPermi('system:websites:add')")
    @Log(title = "网站管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Websites websites)
    {
        return toAjax(websitesService.insertWebsites(websites));
    }

    /**
     * 修改网站管理
     */
    @PreAuthorize("@ss.hasPermi('system:websites:edit')")
    @Log(title = "网站管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Websites websites)
    {
        return toAjax(websitesService.updateWebsites(websites));
    }

    /**
     * 删除网站管理
     */
    @PreAuthorize("@ss.hasPermi('system:websites:remove')")
    @Log(title = "网站管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(websitesService.deleteWebsitesByIds(ids));
    }
}
