package com.censoft.censoftrongtong.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.censoft.censoftrongtong.domain.LedgerFloor;
import com.censoft.censoftrongtong.domain.LedgerRoom;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 基础数据-楼层Mapper接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface LedgerRoomMapper extends BaseMapper<LedgerRoom>
{
    /**
     * 查询基础数据-房间列表
     *
     * @param ledgerRoom 基础数据-房间
     * @return 基础数据-房间集合
     */
    /**
     * 查询基础数据-楼层列表
     *
     * @param ledgerRoom 基础数据-楼层
     * @return 基础数据-楼层集合
     */
    public List<LedgerRoom> selectLedgerRoomList(LedgerRoom ledgerRoom);

    String getLevelColorByRoomId(@Param("roomId") Long roomId);
}
