package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.RiskExistingList;
import com.censoft.censoftrongtong.service.IRiskExistingListService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 现有风险清单库Controller
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@RestController
@RequestMapping("/system/risk/existing/list")
public class RiskExistingListController extends BaseController
{
    @Autowired
    private IRiskExistingListService riskExistingListService;

    /**
     * 查询现有风险清单库列表
     */
    @PreAuthorize("@ss.hasPermi('system:riskExisting:list')")
    @GetMapping("/list")
    public TableDataInfo list(RiskExistingList riskExistingList)
    {
        startPage();
        List<RiskExistingList> list = riskExistingListService.selectRiskExistingListList(riskExistingList);
        return getDataTable(list);
    }

    /**
     * 导出现有风险清单库列表
     */
    @PreAuthorize("@ss.hasPermi('system:riskExisting:export')")
    @Log(title = "现有风险清单库", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, RiskExistingList riskExistingList)
    {
        List<RiskExistingList> list = riskExistingListService.selectRiskExistingListList(riskExistingList);
        ExcelUtil<RiskExistingList> util = new ExcelUtil<RiskExistingList>(RiskExistingList.class);
        util.exportExcel(response, list, "现有风险清单库数据");
    }

    /**
     * 获取现有风险清单库详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:riskExisting:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(riskExistingListService.selectRiskExistingListById(id));
    }

    /**
     * 新增现有风险清单库
     */
    @PreAuthorize("@ss.hasPermi('system:riskExisting:add')")
    @Log(title = "现有风险清单库", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RiskExistingList riskExistingList)
    {
        return toAjax(riskExistingListService.insertRiskExistingList(riskExistingList));
    }

    /**
     * 修改现有风险清单库
     */
    @PreAuthorize("@ss.hasPermi('system:riskExisting:edit')")
    @Log(title = "现有风险清单库", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RiskExistingList riskExistingList)
    {
        return toAjax(riskExistingListService.updateRiskExistingList(riskExistingList));
    }

    /**
     * 删除现有风险清单库
     */
    @PreAuthorize("@ss.hasPermi('system:riskExisting:remove')")
    @Log(title = "现有风险清单库", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(riskExistingListService.deleteRiskExistingListByIds(ids));
    }
}
