package com.censoft.censoftrongtong.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 法律法规库对象 law_list
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public class LawList extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 标题 */
    @Excel(name = "标题")
    private String name;

    /** 类型 */
    @Excel(name = "类型")
    private String type;

    /** 简述 */
    @Excel(name = "简述")
    private String sketch;

    /** 范围 */
    @Excel(name = "范围")
    private String range;

    /** 规范性引用文件 */
    @Excel(name = "规范性引用文件")
    private String normativeReferences;

    /** 颁布日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "颁布日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date issueDate;

    /** 实施日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "实施日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date implementationDate;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setType(String type) 
    {
        this.type = type;
    }

    public String getType() 
    {
        return type;
    }
    public void setSketch(String sketch) 
    {
        this.sketch = sketch;
    }

    public String getSketch() 
    {
        return sketch;
    }
    public void setRange(String range) 
    {
        this.range = range;
    }

    public String getRange() 
    {
        return range;
    }
    public void setNormativeReferences(String normativeReferences) 
    {
        this.normativeReferences = normativeReferences;
    }

    public String getNormativeReferences() 
    {
        return normativeReferences;
    }
    public void setIssueDate(Date issueDate) 
    {
        this.issueDate = issueDate;
    }

    public Date getIssueDate() 
    {
        return issueDate;
    }
    public void setImplementationDate(Date implementationDate) 
    {
        this.implementationDate = implementationDate;
    }

    public Date getImplementationDate() 
    {
        return implementationDate;
    }
    public void setDelFlag(String delFlag) 
    {
        this.delFlag = delFlag;
    }

    public String getDelFlag() 
    {
        return delFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("type", getType())
            .append("sketch", getSketch())
            .append("range", getRange())
            .append("normativeReferences", getNormativeReferences())
            .append("issueDate", getIssueDate())
            .append("implementationDate", getImplementationDate())
            .append("delFlag", getDelFlag())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
