package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.LedgerFloor;
import com.censoft.censoftrongtong.service.ILedgerFloorService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 基础数据-楼层Controller
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@RestController
@RequestMapping("/system/ledger/floor")
public class LedgerFloorController extends BaseController
{
    @Autowired
    private ILedgerFloorService ledgerFloorService;

    /**
     * 查询基础数据-楼层列表
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerFloor:list')")
    @GetMapping("/list")
    public TableDataInfo list(LedgerFloor ledgerFloor)
    {
        startPage();
        List<LedgerFloor> list = ledgerFloorService.selectLedgerFloorList(ledgerFloor);
        return getDataTable(list);
    }

    /**
     * 导出基础数据-楼层列表
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerFloor:export')")
    @Log(title = "基础数据-楼层", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LedgerFloor ledgerFloor)
    {
        List<LedgerFloor> list = ledgerFloorService.selectLedgerFloorList(ledgerFloor);
        ExcelUtil<LedgerFloor> util = new ExcelUtil<LedgerFloor>(LedgerFloor.class);
        util.exportExcel(response, list, "基础数据-楼层数据");
    }

    /**
     * 获取基础数据-楼层详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerFloor:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ledgerFloorService.selectLedgerFloorById(id));
    }

    /**
     * 新增基础数据-楼层
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerFloor:add')")
    @Log(title = "基础数据-楼层", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody LedgerFloor ledgerFloor)
    {
        return toAjax(ledgerFloorService.insertLedgerFloor(ledgerFloor));
    }

    /**
     * 修改基础数据-楼层
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerFloor:edit')")
    @Log(title = "基础数据-楼层", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody LedgerFloor ledgerFloor)
    {
        return toAjax(ledgerFloorService.updateLedgerFloor(ledgerFloor));
    }

    /**
     * 删除基础数据-楼层
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerFloor:remove')")
    @Log(title = "基础数据-楼层", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ledgerFloorService.deleteLedgerFloorByIds(ids));
    }
}
