package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.RiskExistingList;

import java.util.List;

/**
 * 现有风险清单库Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface IRiskExistingListService 
{
    /**
     * 查询现有风险清单库
     * 
     * @param id 现有风险清单库主键
     * @return 现有风险清单库
     */
    public RiskExistingList selectRiskExistingListById(Long id);

    /**
     * 查询现有风险清单库列表
     * 
     * @param riskExistingList 现有风险清单库
     * @return 现有风险清单库集合
     */
    public List<RiskExistingList> selectRiskExistingListList(RiskExistingList riskExistingList);

    /**
     * 新增现有风险清单库
     * 
     * @param riskExistingList 现有风险清单库
     * @return 结果
     */
    public int insertRiskExistingList(RiskExistingList riskExistingList);

    /**
     * 修改现有风险清单库
     * 
     * @param riskExistingList 现有风险清单库
     * @return 结果
     */
    public int updateRiskExistingList(RiskExistingList riskExistingList);

    /**
     * 批量删除现有风险清单库
     * 
     * @param ids 需要删除的现有风险清单库主键集合
     * @return 结果
     */
    public int deleteRiskExistingListByIds(Long[] ids);

    /**
     * 删除现有风险清单库信息
     * 
     * @param id 现有风险清单库主键
     * @return 结果
     */
    public int deleteRiskExistingListById(Long id);
}
