package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.TableName;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 固有风险清单库对象 risk_plan_inherent_list
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public class RiskPlanInherentList extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long id;

    /** 评估人id */
    @Excel(name = "评估人id")
    private Long userId;

    /** 房间id */
    @Excel(name = "房间id")
    private Long roomId;

    /** 计划id */
    @Excel(name = "计划id")
    private Long planId;

    /** 风险code */
    @Excel(name = "风险code")
    private String code;

    /** 风险源名称 */
    @Excel(name = "风险源名称")
    private String name;

    /** 风险类型 */
    @Excel(name = "风险类型")
    private String type;

    /** 风险描述 */
    @Excel(name = "风险描述")
    private String describe;

    /** 评估模型 */
    @Excel(name = "评估模型")
    private String evaluationModel;

    /** 评估范围 */
    @Excel(name = "评估范围")
    private String evaluationRange;

    /** 风险等级 */
    @Excel(name = "风险等级")
    private String level;

    /** 存在部位 */
    @Excel(name = "存在部位")
    private String presenceLocation;

    /** 风险源照片id */
    @Excel(name = "风险源照片id")
    private String pictureFileIds;

    /** 风险因素 */
    @Excel(name = "风险因素")
    private String factor;

    /** 工程技术措施 */
    @Excel(name = "工程技术措施")
    private String measuresProject;

    /** 工程技术措施附件 */
    @Excel(name = "工程技术措施附件")
    private String measuresProjectFileIds;

    /** 管理措施 */
    @Excel(name = "管理措施")
    private String measuresAdministration;

    /** 管理措施附件 */
    @Excel(name = "管理措施附件")
    private String measuresAdministrationFileIds;

    /** 应急处置措施 */
    @Excel(name = "应急处置措施")
    private String measuresEmergency;

    /** 应急处置措施附件 */
    @Excel(name = "应急处置措施附件")
    private String measuresEmergencyFileIds;

    /** 参考依据 */
    @Excel(name = "参考依据")
    private String referenceBasis;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setRoomId(Long roomId) 
    {
        this.roomId = roomId;
    }

    public Long getRoomId() 
    {
        return roomId;
    }
    public void setPlanId(Long planId) 
    {
        this.planId = planId;
    }

    public Long getPlanId() 
    {
        return planId;
    }
    public void setCode(String code) 
    {
        this.code = code;
    }

    public String getCode() 
    {
        return code;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setType(String type) 
    {
        this.type = type;
    }

    public String getType() 
    {
        return type;
    }
    public void setDescribe(String describe) 
    {
        this.describe = describe;
    }

    public String getDescribe() 
    {
        return describe;
    }
    public void setEvaluationModel(String evaluationModel) 
    {
        this.evaluationModel = evaluationModel;
    }

    public String getEvaluationModel() 
    {
        return evaluationModel;
    }
    public void setEvaluationRange(String evaluationRange) 
    {
        this.evaluationRange = evaluationRange;
    }

    public String getEvaluationRange() 
    {
        return evaluationRange;
    }
    public void setLevel(String level) 
    {
        this.level = level;
    }

    public String getLevel() 
    {
        return level;
    }
    public void setPresenceLocation(String presenceLocation) 
    {
        this.presenceLocation = presenceLocation;
    }

    public String getPresenceLocation() 
    {
        return presenceLocation;
    }
    public void setPictureFileIds(String pictureFileIds) 
    {
        this.pictureFileIds = pictureFileIds;
    }

    public String getPictureFileIds() 
    {
        return pictureFileIds;
    }
    public void setFactor(String factor) 
    {
        this.factor = factor;
    }

    public String getFactor() 
    {
        return factor;
    }
    public void setMeasuresProject(String measuresProject) 
    {
        this.measuresProject = measuresProject;
    }

    public String getMeasuresProject() 
    {
        return measuresProject;
    }
    public void setMeasuresProjectFileIds(String measuresProjectFileIds) 
    {
        this.measuresProjectFileIds = measuresProjectFileIds;
    }

    public String getMeasuresProjectFileIds() 
    {
        return measuresProjectFileIds;
    }
    public void setMeasuresAdministration(String measuresAdministration) 
    {
        this.measuresAdministration = measuresAdministration;
    }

    public String getMeasuresAdministration() 
    {
        return measuresAdministration;
    }
    public void setMeasuresAdministrationFileIds(String measuresAdministrationFileIds) 
    {
        this.measuresAdministrationFileIds = measuresAdministrationFileIds;
    }

    public String getMeasuresAdministrationFileIds() 
    {
        return measuresAdministrationFileIds;
    }
    public void setMeasuresEmergency(String measuresEmergency) 
    {
        this.measuresEmergency = measuresEmergency;
    }

    public String getMeasuresEmergency() 
    {
        return measuresEmergency;
    }
    public void setMeasuresEmergencyFileIds(String measuresEmergencyFileIds) 
    {
        this.measuresEmergencyFileIds = measuresEmergencyFileIds;
    }

    public String getMeasuresEmergencyFileIds() 
    {
        return measuresEmergencyFileIds;
    }
    public void setReferenceBasis(String referenceBasis) 
    {
        this.referenceBasis = referenceBasis;
    }

    public String getReferenceBasis() 
    {
        return referenceBasis;
    }
    public void setDelFlag(String delFlag) 
    {
        this.delFlag = delFlag;
    }

    public String getDelFlag() 
    {
        return delFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("userId", getUserId())
            .append("roomId", getRoomId())
            .append("planId", getPlanId())
            .append("code", getCode())
            .append("name", getName())
            .append("type", getType())
            .append("describe", getDescribe())
            .append("evaluationModel", getEvaluationModel())
            .append("evaluationRange", getEvaluationRange())
            .append("level", getLevel())
            .append("presenceLocation", getPresenceLocation())
            .append("pictureFileIds", getPictureFileIds())
            .append("factor", getFactor())
            .append("measuresProject", getMeasuresProject())
            .append("measuresProjectFileIds", getMeasuresProjectFileIds())
            .append("measuresAdministration", getMeasuresAdministration())
            .append("measuresAdministrationFileIds", getMeasuresAdministrationFileIds())
            .append("measuresEmergency", getMeasuresEmergency())
            .append("measuresEmergencyFileIds", getMeasuresEmergencyFileIds())
            .append("referenceBasis", getReferenceBasis())
            .append("delFlag", getDelFlag())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
