package com.censoft.censoftrongtong.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.censoft.censoftrongtong.mapper.CurrentRiskPostListMapper;
import com.censoft.censoftrongtong.domain.CurrentRiskPostList;
import com.censoft.censoftrongtong.service.ICurrentRiskPostListService;
import com.github.yulichang.base.MPJBaseServiceImpl;
/**
 * 现状风险岗位用户巡查清单Service业务层处理
 * 
 * @author bobbao
 * @date 2023-12-07
 */
@Service
public class CurrentRiskPostListServiceImpl extends MPJBaseServiceImpl<CurrentRiskPostListMapper, CurrentRiskPostList> implements ICurrentRiskPostListService
{
    @Autowired
    private CurrentRiskPostListMapper currentRiskPostListMapper;

    /**
     * 查询现状风险岗位用户巡查清单
     * 
     * @param id 现状风险岗位用户巡查清单主键
     * @return 现状风险岗位用户巡查清单
     */
    @Override
    public CurrentRiskPostList selectCurrentRiskPostListById(Long id)
    {
        return currentRiskPostListMapper.selectCurrentRiskPostListById(id);
    }

    /**
     * 查询现状风险岗位用户巡查清单列表
     * 
     * @param currentRiskPostList 现状风险岗位用户巡查清单
     * @return 现状风险岗位用户巡查清单
     */
    @Override
    public List<CurrentRiskPostList> selectCurrentRiskPostListList(CurrentRiskPostList currentRiskPostList)
    {
        return currentRiskPostListMapper.selectCurrentRiskPostListList(currentRiskPostList);
    }

    /**
     * 新增现状风险岗位用户巡查清单
     * 
     * @param currentRiskPostList 现状风险岗位用户巡查清单
     * @return 结果
     */
    @Override
    public int insertCurrentRiskPostList(CurrentRiskPostList currentRiskPostList)
    {
        currentRiskPostList.setCreateTime(DateUtils.getNowDate());
        return currentRiskPostListMapper.insertCurrentRiskPostList(currentRiskPostList);
    }

    /**
     * 修改现状风险岗位用户巡查清单
     * 
     * @param currentRiskPostList 现状风险岗位用户巡查清单
     * @return 结果
     */
    @Override
    public int updateCurrentRiskPostList(CurrentRiskPostList currentRiskPostList)
    {
        currentRiskPostList.setUpdateTime(DateUtils.getNowDate());
        return currentRiskPostListMapper.updateCurrentRiskPostList(currentRiskPostList);
    }

    /**
     * 批量删除现状风险岗位用户巡查清单
     * 
     * @param ids 需要删除的现状风险岗位用户巡查清单主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskPostListByIds(Long[] ids)
    {
        return currentRiskPostListMapper.deleteCurrentRiskPostListByIds(ids);
    }

    /**
     * 删除现状风险岗位用户巡查清单信息
     * 
     * @param id 现状风险岗位用户巡查清单主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskPostListById(Long id)
    {
        return currentRiskPostListMapper.deleteCurrentRiskPostListById(id);
    }

    @Override
    public List<CurrentRiskPostList> selectCurrentRiskPostListList2(CurrentRiskPostList currentRiskPostList) {
        return currentRiskPostListMapper.selectCurrentRiskPostListList2(currentRiskPostList);
    }
}
