package com.censoft.censoftrongtong.domain;

import com.ruoyi.common.core.domain.BaseEntityClean;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import java.util.List;

/**
 * 现状风险岗位对象 current_risk_post
 * 
 * @author ruoyi
 * @date 2023-12-01
 */
@Data
public class CurrentRiskPost extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** 主键 id */
    private Long id;

    /** 项目id */
    @Excel(name = "项目id")
    private Long projectId;

    /** 岗位编码 */
    @Excel(name = "岗位编码")
    private String riskPostCode;

    /** 岗位名称 */
    @Excel(name = "岗位名称")
    private String riskPostName;

    /** 巡查类型 */
    @Excel(name = "巡查类型 0 一岗一人 1 一岗多人")
    private String patrolType;

    /** 岗位描述 */
    @Excel(name = "岗位描述")
    private String riskPostDesc;

    /** 用户 id */
    @Excel(name = "用户 id")
    private String userId;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNum;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    private String nickName;

    private List<CurrentRiskPostListSaveVO> list;
}
