package com.censoft.censoftrongtong.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 风险计划任务对象 risk_plan_task
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public class RiskPlanTask extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long id;

    /** 计划id */
    @Excel(name = "计划id")
    private Long planId;

    /** 任务状态key值 */
    @Excel(name = "任务状态key值")
    private String taskKey;

    /** 任务名称 */
    @Excel(name = "任务名称")
    private String taskName;

    /** 经办结果 */
    @Excel(name = "经办结果")
    private String taskResult;

    /** 经办意见 */
    @Excel(name = "经办意见")
    private String taskOpinion;

    /** 状态 */
    @Excel(name = "状态")
    private String status;

    /** 审批人id */
    @Excel(name = "审批人id")
    private Long approvalUserId;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 提交时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "提交时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date completedTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setPlanId(Long planId) 
    {
        this.planId = planId;
    }

    public Long getPlanId() 
    {
        return planId;
    }
    public void setTaskName(String taskName) 
    {
        this.taskName = taskName;
    }

    public String getTaskName() 
    {
        return taskName;
    }
    public void setTaskResult(String taskResult) 
    {
        this.taskResult = taskResult;
    }

    public String getTaskResult() 
    {
        return taskResult;
    }
    public void setTaskOpinion(String taskOpinion) 
    {
        this.taskOpinion = taskOpinion;
    }

    public String getTaskOpinion() 
    {
        return taskOpinion;
    }

    public String getTaskKey() {
        return taskKey;
    }

    public void setTaskKey(String taskKey) {
        this.taskKey = taskKey;
    }

    public void setStatus(String status)
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setApprovalUserId(Long approvalUserId) 
    {
        this.approvalUserId = approvalUserId;
    }

    public Long getApprovalUserId() 
    {
        return approvalUserId;
    }
    public void setStartTime(Date startTime) 
    {
        this.startTime = startTime;
    }

    public Date getStartTime() 
    {
        return startTime;
    }
    public void setCompletedTime(Date completedTime) 
    {
        this.completedTime = completedTime;
    }

    public Date getCompletedTime() 
    {
        return completedTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("planId", getPlanId())
            .append("taskName", getTaskName())
            .append("taskResult", getTaskResult())
            .append("taskOpinion", getTaskOpinion())
            .append("status", getStatus())
            .append("approvalUserId", getApprovalUserId())
            .append("startTime", getStartTime())
            .append("completedTime", getCompletedTime())
            .toString();
    }
}
