package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.censoft.censoftrongtong.domain.LedgerProject;
import com.censoft.censoftrongtong.service.ILedgerProjectService;
import com.ruoyi.common.core.domain.R;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 基础数据-项目Controller
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@RestController
@RequestMapping("/system/ledger/project")
public class LedgerProjectController extends BaseController
{
    @Autowired
    private ILedgerProjectService ledgerProjectService;

    /**
     * 查询基础数据-项目列表
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerProject:list')")
    @GetMapping("/list")
    public TableDataInfo list(LedgerProject ledgerProject)
    {
        startPage();
        List<LedgerProject> list = ledgerProjectService.selectLedgerProjectList(ledgerProject);
        return getDataTable(list);
    }

    /**
     * 导出基础数据-项目列表
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerProject:export')")
    @Log(title = "基础数据-项目", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LedgerProject ledgerProject)
    {
        List<LedgerProject> list = ledgerProjectService.selectLedgerProjectList(ledgerProject);
        ExcelUtil<LedgerProject> util = new ExcelUtil<LedgerProject>(LedgerProject.class);
        util.exportExcel(response, list, "基础数据-项目数据");
    }

    /**
     * 获取基础数据-项目详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerProject:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ledgerProjectService.selectLedgerProjectById(id));
    }

    /**
     * 新增基础数据-项目
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerProject:add')")
    @Log(title = "基础数据-项目", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody LedgerProject ledgerProject)
    {
        return toAjax(ledgerProjectService.insertLedgerProject(ledgerProject));
    }

    /**
     * 修改基础数据-项目
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerProject:edit')")
    @Log(title = "基础数据-项目", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody LedgerProject ledgerProject)
    {
        return toAjax(ledgerProjectService.updateLedgerProject(ledgerProject));
    }

    /**
     * 删除基础数据-项目
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerProject:remove')")
    @Log(title = "基础数据-项目", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ledgerProjectService.deleteLedgerProjectByIds(ids));
    }

    /**
     * 查询项目列表
     * @param projectName
     * @return
     */
    @GetMapping("/listByQuery/{projectName}")
    public R<List<LedgerProject>> listByQuery(@PathVariable String  projectName)
    {
        QueryWrapper<LedgerProject> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("name","id","business").lambda().like(LedgerProject::getName,projectName);
        List<LedgerProject> list = ledgerProjectService.list(queryWrapper);
        return R.ok(list);
    }


}
