package com.censoft.censoftrongtong.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.constant.UserConstants;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysMenu;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysMenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 菜单信息
 * 
 * @author ruoyi
 */
@RestController
@RequestMapping("/app-api/menu2")
public class SysMenuAppController extends BaseController
{
    @Autowired
    private ISysMenuService menuService;

    /**
     * 查询角色菜单列表信息
     */
    @GetMapping(value = "/roleMenuTreeselect")
    public AjaxResult roleMenuTreeselect()
    {
        //根数据
        List<SysMenu> rootList = new ArrayList<>();
        //初始化树
        AjaxResult ajax = AjaxResult.success();
        List<SysMenu> list = menuService.queryMenu(getUserId());
        if(CollectionUtils.isEmpty(list)){
            return ajax;
        }
        list.stream().filter(sysMenu -> 0L == sysMenu.getParentId()).forEach(rootList::add);
        SysMenu sysMenu = rootList.get(0);
        buildTreeNew(sysMenu,list);
        ajax.put("list", sysMenu.getChildren());
        return ajax;
    }

    public static void buildTreeNew(SysMenu root, List<SysMenu> nodeList) {
        //step1 找出所有的下级
        List<SysMenu> resultList = new ArrayList<>();
        nodeList.forEach(node ->{
            //如果id对应，则为下级
            if(root.getMenuId().equals(node.getParentId())){
                //递归查找下级的下级
                buildTreeNew(node,nodeList);
                resultList.add(node);
            }
        });
        root.setChildren(resultList);
    }
}