package com.ruoyi.system.service;

import com.ruoyi.system.domain.SysUploadFile;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 文件Service接口
 * 
 * @author hzhou
 * @date 2022-08-18
 */
public interface ISysUploadFileService
{
    /**
     * 查询文件
     * 
     * @param fileId 文件主键
     * @return 文件
     */
    public SysUploadFile selectSysFileByFileId(Long fileId);

    /**
     * 查询文件列表
     * 
     * @param sysUploadFile 文件
     * @return 文件集合
     */
    public List<SysUploadFile> selectSysFileList(SysUploadFile sysUploadFile);

    /**
     * 新增文件
     * 
     * @param sysUploadFile 文件
     * @return 结果
     */
    public int insertSysFile(SysUploadFile sysUploadFile);

    /**
     * 修改文件
     * 
     * @param sysUploadFile 文件
     * @return 结果
     */
    public int updateSysFile(SysUploadFile sysUploadFile);

    /**
     * 批量删除文件
     * 
     * @param fileIds 需要删除的文件主键集合
     * @return 结果
     */
    public int deleteSysFileByFileIds(Long[] fileIds);

    /**
     * 删除文件信息
     * 
     * @param fileId 文件主键
     * @return 结果
     */
    public int deleteSysFileByFileId(Long fileId);

    /**
     * 上传通用服务
     *
     * @param file 文件
     * @return 结果
     */
    public Long upload(MultipartFile file,String filePath,String userName,String url);

    public List<SysUploadFile> selectSysFileByFileIds(List<Long> fileIds);
}
