package com.censoft.censoftrongtong.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.censoft.censoftrongtong.domain.EvaluationFactorItems;
import com.censoft.censoftrongtong.domain.EvaluationModelInfo;
import com.censoft.censoftrongtong.domain.dto.EvaluationFactorItemsDto;
import com.censoft.censoftrongtong.mapper.EvaluationFactorItemsMapper;
import com.censoft.censoftrongtong.mapper.EvaluationModelInfoMapper;
import com.censoft.censoftrongtong.service.IEvaluationModelInfoService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.Validator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.ruoyi.common.utils.SecurityUtils.getLoginUser;

/**
 * 评估模型信息Service业务层处理
 * 
 * @author xjchen
 * @date 2023-08-08
 */
@Service
public class EvaluationModelInfoServiceImpl extends MPJBaseServiceImpl<EvaluationModelInfoMapper, EvaluationModelInfo> implements IEvaluationModelInfoService
{
    @Autowired
    private EvaluationModelInfoMapper evaluationModelInfoMapper;

    @Autowired
    private EvaluationFactorItemsMapper evaluationFactorItemsMapper;



    @Autowired
    protected Validator validator;

    /**
     * 查询评估模型信息
     * 
     * @param id 评估模型信息主键
     * @return 评估模型信息
     */
    @Override
    public EvaluationModelInfo selectEvaluationModelInfoById(Long id)
    {
        return evaluationModelInfoMapper.selectEvaluationModelInfoById(id);
    }

    /**
     * 查询评估模型信息列表
     * 
     * @param evaluationModelInfo 评估模型信息
     * @return 评估模型信息
     */
    @Override
    public List<EvaluationModelInfo> selectEvaluationModelInfoList(EvaluationModelInfo evaluationModelInfo)
    {
        return evaluationModelInfoMapper.selectEvaluationModelInfoList(evaluationModelInfo);
    }

    /**
     * 新增评估模型信息
     * 
     * @param evaluationModelInfo 评估模型信息
     * @return 结果
     */
    @Override
    public int insertEvaluationModelInfo(EvaluationModelInfo evaluationModelInfo)
    {
        evaluationModelInfo.setCreateTime(DateUtils.getNowDate());
        evaluationModelInfo.setCreateBy(getLoginUser().getUserId()+"");
        return evaluationModelInfoMapper.insertEvaluationModelInfo(evaluationModelInfo);
    }

    /**
     * 修改评估模型信息
     * 
     * @param evaluationModelInfo 评估模型信息
     * @return 结果
     */
    @Override
    public int updateEvaluationModelInfo(EvaluationModelInfo evaluationModelInfo)
    {
        evaluationModelInfo.setUpdateTime(DateUtils.getNowDate());
        evaluationModelInfo.setCreateBy(getLoginUser().getUserId()+"");
        return evaluationModelInfoMapper.updateEvaluationModelInfo(evaluationModelInfo);
    }

    /**
     * 批量删除评估模型信息
     * 
     * @param ids 需要删除的评估模型信息主键
     * @return 结果
     */
    @Override
    public int deleteEvaluationModelInfoByIds(Long[] ids)
    {
        return evaluationModelInfoMapper.deleteEvaluationModelInfoByIds(ids);
    }

    /**
     * 删除评估模型信息信息
     * 
     * @param id 评估模型信息主键
     * @return 结果
     */
    @Override
    public int deleteEvaluationModelInfoById(Long id)
    {
        return evaluationModelInfoMapper.deleteEvaluationModelInfoById(id);
    }
    /**
     * 导入因素数据
     *
     * @param factorItemListDtoList 因素数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param operName 操作用户
     * @return 结果
     */
    @Override
    public String importUser(List<EvaluationFactorItemsDto> factorItemListDtoList, Boolean isUpdateSupport, String operName)
    {
        if (StringUtils.isNull(factorItemListDtoList) || factorItemListDtoList.size() == 0)
        {
            throw new ServiceException("导入评估数据不能为空！");
        }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        int k=0;
        for (EvaluationFactorItemsDto factorItemsDto : factorItemListDtoList)
        {
            try
            {
                // 验证是否存在这个因素
                QueryWrapper<EvaluationModelInfo> quModel = new QueryWrapper<>();
                quModel.lambda().eq(EvaluationModelInfo::getInfluenceFactor,factorItemsDto.getInfluenceFactor()).eq(EvaluationModelInfo::getInfluenceSubFactor,factorItemsDto.getInfluenceSubFactor());
                EvaluationModelInfo modelInfo = evaluationModelInfoMapper.selectOne(quModel);
                if (StringUtils.isNull(modelInfo))
                {
                    //BeanValidators.validateWithException(validator, factorItemsDto);
                    EvaluationModelInfo evaluationModelInfo=new EvaluationModelInfo();
                     BeanUtils.copyProperties(factorItemsDto,evaluationModelInfo);
                    evaluationModelInfo.setCreateTime(new Date());
                    evaluationModelInfo.setCreateBy(operName);
                    evaluationModelInfo.setSortNum(++k);
                    evaluationModelInfo.setDelFlag("0");
                    int rs=evaluationModelInfoMapper.insert(evaluationModelInfo);//插入因素
                    if (rs>0) {//插入选项
                        String [] indicatorBelongArr={"指标项一","指标项二","指标项三","指标项四"};
                        List<String> list_items=new ArrayList<>();
                        list_items.add(StringUtils.isNotEmpty(factorItemsDto.getIndicatorItem1())?factorItemsDto.getIndicatorItem1():"");
                        list_items.add(StringUtils.isNotEmpty(factorItemsDto.getIndicatorItem2())?factorItemsDto.getIndicatorItem2():"");
                        list_items.add(StringUtils.isNotEmpty(factorItemsDto.getIndicatorItem3())?factorItemsDto.getIndicatorItem3():"");
                        list_items.add(StringUtils.isNotEmpty(factorItemsDto.getIndicatorItem4())?factorItemsDto.getIndicatorItem4():"");
                        for (int i = 0; i < list_items.size(); i++) {

                            String itemStr=list_items.get(i);
                            if (itemStr==null||itemStr.equals("")) {
                                continue;
                            }
                            EvaluationFactorItems evaluationFactorItems=new EvaluationFactorItems();
                            evaluationFactorItems.setIndicatorBelong(indicatorBelongArr[i]);
                            evaluationFactorItems.setIndicatorItem(itemStr);
                            evaluationFactorItems.setIndicatorScore(i+1);
                            evaluationFactorItems.setSortNum(i+1);
                            evaluationFactorItems.setDelFlag("0");
                            evaluationFactorItems.setCreateBy(operName);
                            evaluationFactorItems.setCreateTime(new Date());
                            evaluationFactorItems.setFactorId(evaluationModelInfo.getId());
                            if(factorItemsDto.getIsImportant().equals("1")&&i==list_items.size()-1){
                            evaluationFactorItems.setIsImportant("1");
                            }else {
                                evaluationFactorItems.setIsImportant("0");
                            }
                            evaluationFactorItemsMapper.insert(evaluationFactorItems);

                        }


                    }


                    successNum++;
                    successMsg.append("<br/>" + successNum + "、账号 " + factorItemsDto.getInfluenceFactor() + " 导入成功");
                }
                else if (isUpdateSupport)
                {
                    //BeanValidators.validateWithException(validator, user);
                    //checkUserAllowed(u);
                    //checkUserDataScope(u.getUserId());
                    //user.setUserId(u.getUserId());
                    //user.setUpdateBy(operName);
                    //userMapper.updateUser(user);
                    //successNum++;
                    //successMsg.append("<br/>" + successNum + "、账号 " + user.getUserName() + " 更新成功");
                }
                else
                {
                    failureNum++;
                    failureMsg.append("<br/>" + failureNum + "、账号 " + factorItemsDto.getInfluenceFactor() + " 已存在");
                }
            }
            catch (Exception e)
            {
                failureNum++;
                String msg = "<br/>" + failureNum + "、账号 " + factorItemsDto.getInfluenceFactor() + " 导入失败：";
                failureMsg.append(msg + e.getMessage());
                log.error(msg, e);
            }
        }
        if (failureNum > 0)
        {
            failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        }
        else
        {
            successMsg.insert(0, "恭喜您，数据已全部导入成功！共 " + successNum + " 条，数据如下：");
        }
        return successMsg.toString();
    }
}
