package com.censoft.censoftrongtong.service.impl;

import com.censoft.censoftrongtong.service.ICommonMessageInfoService;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.BacklogInfo;
import com.ruoyi.system.domain.MessageInfo;
import com.ruoyi.system.mapper.BacklogInfoMapper;
import com.ruoyi.system.mapper.MessageInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.UUID;

public class CommonMessageInfoServiceImpl implements ICommonMessageInfoService {
    @Autowired
    private MessageInfoMapper messageInfoMapper;

    @Autowired
    private BacklogInfoMapper backlogInfoMapper;

    /**
     * 新增消息信息
     *
     * @return 结果
     */
    @Override
    public int insertMessageInfo(String pid, String nodeId, String title, String content, String status, String messageBy, String menuName, String menuUrl, String appUrl, String createBy) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setId(UUID.randomUUID().toString().replace("-", ""));
        if (StringUtils.isNotNull(pid) && StringUtils.isNotEmpty(pid)) {
            messageInfo.setPid(pid);
        }
        if (StringUtils.isNotNull(nodeId) && StringUtils.isNotEmpty(nodeId)) {
            messageInfo.setNodeId(nodeId);
        }
        if (StringUtils.isNotNull(title) && StringUtils.isNotEmpty(title)) {
            messageInfo.setTitle(title);
        }
        if (StringUtils.isNotNull(content) && StringUtils.isNotEmpty(content)) {
            messageInfo.setContent(content);
        }
        if (StringUtils.isNotNull(status) && StringUtils.isNotEmpty(status)) {
            messageInfo.setStatus(status);
        }
        if (StringUtils.isNotNull(messageBy) && StringUtils.isNotEmpty(messageBy)) {
            messageInfo.setMessageBy(messageBy);
        }
        if (StringUtils.isNotNull(menuName) && StringUtils.isNotEmpty(menuName)) {
            messageInfo.setMenuName(menuName);
        }
        if (StringUtils.isNotNull(menuUrl) && StringUtils.isNotEmpty(menuUrl)) {
            messageInfo.setMenuUrl(menuUrl);
        }
        if (StringUtils.isNotNull(appUrl) && StringUtils.isNotEmpty(appUrl)) {
            messageInfo.setAppUrl(appUrl);
        }
        if (StringUtils.isNotNull(createBy) && StringUtils.isNotEmpty(createBy)) {
            messageInfo.setCreateBy(createBy);
        }
        messageInfo.setCreateTime(DateUtils.getNowDate());
        return messageInfoMapper.insertMessageInfo(messageInfo);
    }

//    /**
//     * 新增通知公告
//     *
//     * @return 结果
//     */
//    @Override
//    public int insertNoticeInfo(String pid, String title, String content, String status, String noticeBy, String menuName, String menuUrl, String appUrl, String createBy) {
//        NoticeInfo noticeInfo = new NoticeInfo();
//        noticeInfo.setId(UUID.randomUUID().toString().replace("-", ""));
//        if (StringUtils.isNotNull(title) && StringUtils.isNotEmpty(title)) {
//            noticeInfo.setTitle(title);
//        }
//        if (StringUtils.isNotNull(content) && StringUtils.isNotEmpty(content)) {
//            noticeInfo.setContent(content);
//        }
//        if (StringUtils.isNotNull(createBy) && StringUtils.isNotEmpty(createBy)) {
//            noticeInfo.setCreateBy(createBy);
//        }
//        noticeInfo.setCreateTime(DateUtils.getNowDate());
//        return noticeInfoMapper.insertNoticeInfo(noticeInfo);
//    }

    /**
     * 新增待办信息
     *
     * @return 结果
     */
    @Override
    public int insertBacklogInfo(String pid, String nodeId, String mainId, String title, String theme, String content, String status, String backlogBy, String menuName, String menuUrl, String appUrl, String createBy) {
        BacklogInfo backlogInfo = new BacklogInfo();
        backlogInfo.setId(UUID.randomUUID().toString().replace("-", ""));
        if (StringUtils.isNotNull(pid) && StringUtils.isNotEmpty(pid)) {
            backlogInfo.setPid(pid);
        }
        if (StringUtils.isNotNull(nodeId) && StringUtils.isNotEmpty(nodeId)) {
            backlogInfo.setNodeId(nodeId);
        }
        if (StringUtils.isNotNull(mainId) && StringUtils.isNotEmpty(mainId)) {
            backlogInfo.setMainId(mainId);
        }
        if (StringUtils.isNotNull(title) && StringUtils.isNotEmpty(title)) {
            backlogInfo.setTitle(title);
        }
        if (StringUtils.isNotNull(theme) && StringUtils.isNotEmpty(theme)) {
            backlogInfo.setTheme(theme);
        }
        if (StringUtils.isNotNull(content) && StringUtils.isNotEmpty(content)) {
            backlogInfo.setContent(content);
        }
        if (StringUtils.isNotNull(status) && StringUtils.isNotEmpty(status)) {
            backlogInfo.setStatus(status);
        }
        if (StringUtils.isNotNull(backlogBy) && StringUtils.isNotEmpty(backlogBy)) {
            backlogInfo.setBacklogBy(backlogBy);
        }
        if (StringUtils.isNotNull(menuName) && StringUtils.isNotEmpty(menuName)) {
            backlogInfo.setMenuName(menuName);
        }
        if (StringUtils.isNotNull(menuUrl) && StringUtils.isNotEmpty(menuUrl)) {
            backlogInfo.setMenuUrl(menuUrl);
        }
        if (StringUtils.isNotNull(appUrl) && StringUtils.isNotEmpty(appUrl)) {
            backlogInfo.setAppUrl(appUrl);
        }
        if (StringUtils.isNotNull(createBy) && StringUtils.isNotEmpty(createBy)) {
            backlogInfo.setCreateBy(createBy);
        }
        backlogInfo.setCreateTime(DateUtils.getNowDate());
        return backlogInfoMapper.insertBacklogInfo(backlogInfo);
    }

    /**
     * 修改待办信息
     *
     * @return 结果
     */
    @Override
    public int updateBacklogInfo(String pid, String nodeId, String status, String updateBy, String menuUrl, String appUrl) {
        BacklogInfo backlogInfo = new BacklogInfo();
        if (StringUtils.isNotNull(pid) && StringUtils.isNotEmpty(pid)) {
            backlogInfo.setPid(pid);
        }
        if (StringUtils.isNotNull(nodeId) && StringUtils.isNotEmpty(nodeId)) {
            backlogInfo.setNodeId(nodeId);
        }
        if (StringUtils.isNotNull(status) && StringUtils.isNotEmpty(status)) {
            backlogInfo.setStatus(status);
        }
        if (StringUtils.isNotNull(menuUrl) && StringUtils.isNotEmpty(menuUrl)) {
            backlogInfo.setMenuUrl(menuUrl);
        }
        if (StringUtils.isNotNull(appUrl) && StringUtils.isNotEmpty(appUrl)) {
            backlogInfo.setAppUrl(appUrl);
        }
        if (StringUtils.isNotNull(updateBy) && StringUtils.isNotEmpty(updateBy)) {
            backlogInfo.setUpdateBy(updateBy);
        }
        backlogInfo.setUpdateTime(DateUtils.getNowDate());
        return backlogInfoMapper.updateBacklogInfo(backlogInfo);
    }

    @Override
    public int updateBacklogInfoByPid(String pid, String nodeId, String status, String updateBy, String menuUrl, String appUrl) {
        BacklogInfo backlogInfo = new BacklogInfo();
        if (StringUtils.isNotNull(pid) && StringUtils.isNotEmpty(pid)) {
            backlogInfo.setPid(pid);
        }
        if (StringUtils.isNotNull(nodeId) && StringUtils.isNotEmpty(nodeId)) {
            backlogInfo.setNodeId(nodeId);
        }
        if (StringUtils.isNotNull(status) && StringUtils.isNotEmpty(status)) {
            backlogInfo.setStatus(status);
        }
        if (StringUtils.isNotNull(menuUrl) && StringUtils.isNotEmpty(menuUrl)) {
            backlogInfo.setMenuUrl(menuUrl);
        }
        if (StringUtils.isNotNull(appUrl) && StringUtils.isNotEmpty(appUrl)) {
            backlogInfo.setAppUrl(appUrl);
        }
        if (StringUtils.isNotNull(updateBy) && StringUtils.isNotEmpty(updateBy)) {
            backlogInfo.setUpdateBy(updateBy);
        }
        backlogInfo.setUpdateTime(DateUtils.getNowDate());
        return backlogInfoMapper.updateBacklogInfoByPid(backlogInfo);
    }
}
