package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;

/**
 * 现状风险岗位用户巡查清单对象 current_risk_post_list
 * 
 * @author bobbao
 * @date 2023-12-07
 */
@Data
public class CurrentRiskPostList extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** 主键 id */
    private Long id;

    /** 项目id */
    @Excel(name = "项目id")
    private Long projectId;

    /** 岗位 id */
    @Excel(name = "岗位 id")
    private Long postId;

    /** 用户 id */
    @Excel(name = "用户 id")
    private Long userId;

    /** 现状风险 id */
    @Excel(name = "现状风险 id")
    private Long currentRiskId;

    private String status;

    /** 巡查类型 */
    @Excel(name = "巡查类型")
    private String patrolType;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNum;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    @TableField(exist = false)
    private String currentRiskType;
    @TableField(exist = false)
    private Long currentRiskId2;
    @TableField(exist = false)
    private String currentRiskType2;
    @TableField(exist = false)
    private String nickName;
}
