package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.RiskInherentList;
import com.censoft.censoftrongtong.service.IRiskInherentListService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 固有风险清单库Controller
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@RestController
@RequestMapping("/system/risk/inherentDB")
public class RiskInherentListController extends BaseController
{
    @Autowired
    private IRiskInherentListService riskInherentListService;

    /**
     * 查询固有风险清单库列表
     */
    @PreAuthorize("@ss.hasPermi('system:riskInherent:list')")
    @GetMapping("/list")
    public TableDataInfo list(RiskInherentList riskInherentList)
    {
        startPage();
        List<RiskInherentList> list = riskInherentListService.selectRiskInherentListList(riskInherentList);
        return getDataTable(list);
    }

    /**
     * 导出固有风险清单库列表
     */
    @PreAuthorize("@ss.hasPermi('system:riskInherent:export')")
    @Log(title = "固有风险清单库", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, RiskInherentList riskInherentList)
    {
        List<RiskInherentList> list = riskInherentListService.selectRiskInherentListList(riskInherentList);
        ExcelUtil<RiskInherentList> util = new ExcelUtil<RiskInherentList>(RiskInherentList.class);
        util.exportExcel(response, list, "固有风险清单库数据");
    }

    /**
     * 获取固有风险清单库详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:riskInherent:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(riskInherentListService.selectRiskInherentListById(id));
    }

    /**
     * 新增固有风险清单库
     */
    @PreAuthorize("@ss.hasPermi('system:riskInherent:add')")
    @Log(title = "固有风险清单库", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RiskInherentList riskInherentList)
    {
        return toAjax(riskInherentListService.insertRiskInherentList(riskInherentList));
    }

    /**
     * 修改固有风险清单库
     */
    @PreAuthorize("@ss.hasPermi('system:riskInherent:edit')")
    @Log(title = "固有风险清单库", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RiskInherentList riskInherentList)
    {
        return toAjax(riskInherentListService.updateRiskInherentList(riskInherentList));
    }

    /**
     * 删除固有风险清单库
     */
    @PreAuthorize("@ss.hasPermi('system:riskInherent:remove')")
    @Log(title = "固有风险清单库", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(riskInherentListService.deleteRiskInherentListByIds(ids));
    }
}
