package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 现有风险清单库对象 risk_plan_existing_list
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
@TableName("risk_plan_existing_list")
public class RiskPlanExistingList extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 评估人id
     */
    @TableField("user_id")
    private Long userId;

    /**
     * 固有风险id
     */
    @TableField("inherent_id")
    private Long inherentId;

    /**
     * 计划id
     */
    @TableField("plan_id")
    private Long planId;

    /**
     * 房间id
     */
    @TableField("room_id")
    private Long roomId;

    /**
     * 风险源名称
     */
    @TableField("name")
    private String name;

    /**
     * 风险因素
     */
    @TableField("factor")
    private String factor;

    /**
     * 准事故类型
     */
    @TableField("type")
    private String type;

    /**
     * 风险等级
     */
    @TableField("level")
    private String level;

    /**
     * 风险等级分数
     */
    @TableField("level_score")
    private BigDecimal levelScore;

    /**
     * 存在部位
     */
    @TableField("presence_location")
    private String presenceLocation;

    /**
     * 风险源照片id
     */
    @TableField("picture_file_ids")
    private String pictureFileIds;


    /**
     * 技术措施
     */
    @TableField("measures_project")
    private String measuresProject;

    /**
     * 技术措施附件
     */
    @TableField("measures_project_file_ids")
    private String measuresProjectFileIds;

    /**
     * 已采取的管控措施
     */
    @TableField("measures_administration")
    private String measuresAdministration;

    /**
     * 管控责任单位
     */
    @TableField("measures_dept_name")
    private String measuresDeptName;

    /**
     * 管控责任人
     */
    @TableField("measures_user_name")
    private String measuresUserName;

    /**
     * 管控责任人联系方式
     */
    @TableField("measures_user_phone")
    private String measuresUserPhone;

    /**
     * 管理措施附件
     */
    @TableField("measures_administration_file_ids")
    private String measuresAdministrationFileIds;

    /**
     * 应急处置措施
     */
    @TableField("measures_emergency")
    private String measuresEmergency;

    /**
     * 应急处置措施附件
     */
    @TableField("measures_emergency_file_ids")
    private String measuresEmergencyFileIds;

    /**
     * 参考依据
     */
    @TableField("reference_basis")
    private String referenceBasis;

    /**
     * 删除标志（0代表存在 1代表删除）
     */
    @TableField("del_flag")
    private String delFlag;
    /**
     * 评估选项ids
     */
    @TableField("evaluation_item_ids")
    private String evaluationItemIds;

    /**
     * 影响因素
     */
    @TableField("factor_items")
    private String factorItems;

    /**
     * 楼栋ID
     */
    @TableField(exist = false)
    private String buildingId;
    /**
     * 楼栋名称
     */
    @TableField(exist = false)
    private String buildingName;
    /**
     * 楼层ID
     */
    @TableField(exist = false)
    private String floorId;
    /**
     * 楼层名称
     */
    @TableField(exist = false)
    private String floorName;

    /**
     * 用户名
     */
    @TableField(exist = false)
    private String userName;
    /**
     * 房间名称
     */
    @TableField(exist = false)
    private String roomName;

    /**
     * 风险等级颜色
     */
    private  String riskColor;

}
