package com.censoft.censoftrongtong.service.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.censoft.censoftrongtong.domain.RiskPlan;
import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.domain.RiskPlanTask;
import com.censoft.censoftrongtong.domain.dto.RiskInherentListSaveDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppExistingListDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppInherentListDetailsDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppInherentListDto;
import com.censoft.censoftrongtong.enums.RiskPlanStatusType;
import com.censoft.censoftrongtong.mapper.RiskPlanInherentListMapper;
import com.censoft.censoftrongtong.mapper.RiskPlanMapper;
import com.censoft.censoftrongtong.mapper.RiskPlanTaskMapper;
import com.censoft.censoftrongtong.service.IRiskPlanInherentListService;
import com.censoft.censoftrongtong.service.IRiskPlanTaskService;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.service.ISysUploadFileService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.hutool.core.date.DateUnit;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;

/**
 * 固有风险清单库Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanInherentListServiceImpl implements IRiskPlanInherentListService {
    @Autowired
    private RiskPlanInherentListMapper riskPlanInherentListMapper;
    @Autowired
    private RiskPlanTaskMapper riskPlanTaskMapper;

    @Autowired
    private RiskPlanMapper riskPlanMapper;

    @Resource
    private ISysUploadFileService uploadFileService;

    @Resource
    private IRiskPlanTaskService riskPlanTaskService;

    /**
     * 查询固有风险清单库
     *
     * @param id 固有风险清单库主键
     * @return 固有风险清单库
     */
    @Override
    public RiskPlanInherentList selectRiskPlanInherentListById(Long id) {
        return riskPlanInherentListMapper.selectRiskPlanInherentListById(id);
    }

    /**
     * 查询固有风险清单库列表
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 固有风险清单库
     */
    @Override
    public List<RiskPlanInherentList> selectRiskPlanInherentListList(RiskPlanInherentList riskPlanInherentList) {
        return riskPlanInherentListMapper.selectRiskPlanInherentListList(riskPlanInherentList);
    }

    /**
     * 新增固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public int insertRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList) {
        /**
         * 解题思路
         * 1.判断当前任务状态是否待执行状态
         * 2.待执行修改执行状态变为已完成否则不操作
         * 3.改为已完成添加任务执行记录
         */
        RiskPlanTask riskPlanTask=riskPlanTaskMapper.getLastRiskPlanTaskByPlanId(riskPlanInherentList.getPlanId());
        //计划
        RiskPlan riskPlan = riskPlanMapper.selectRiskPlanById(riskPlanTask.getPlanId());
        if (riskPlanTask!=null) {
            if (riskPlanTask.getTaskKey().equals("WAIT_START")&&riskPlanTask.getStatus().equals("running")) {
                //修改任务状态
                riskPlanTask.setStatus("completed");
                riskPlanTask.setCompletedTime(new Date());
                int rs=riskPlanTaskMapper.updateRiskPlanTask(riskPlanTask);
                if (rs>-1) {//修改状态成功
                    System.out.println("修改状态成功");
                }
                //创建任务执行状态
                RiskPlanTask riskPlanTask1 = new RiskPlanTask();
                riskPlanTask1.setPlanId(riskPlanTask.getPlanId());
                riskPlanTask1.setApprovalUserId(riskPlan.getLeaderUserId());
                riskPlanTask1.setTaskKey(RiskPlanStatusType.RUNNING.getStatus());
                riskPlanTask1.setTaskName(RiskPlanStatusType.RUNNING.getTitle());
                riskPlanTask1.setStatus("running");
                riskPlanTask1.setStartTime(new Date());
                riskPlanTaskService.insertRiskPlanTask(riskPlanTask1);
            }
        }


        riskPlanInherentList.setCreateTime(DateUtils.getNowDate());
        return riskPlanInherentListMapper.insertRiskPlanInherentList(riskPlanInherentList);
    }

    /**
     * 修改固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public int updateRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList) {
        /**
         * 解题思路
         * 1.判断当前任务状态是否待执行状态
         * 2.待执行修改执行状态变为已完成否则不操作
         * 3.改为已完成添加任务执行记录
         */
        RiskPlanTask riskPlanTask=riskPlanTaskMapper.getLastRiskPlanTaskByPlanId(riskPlanInherentList.getPlanId());
        //计划
        RiskPlan riskPlan = riskPlanMapper.selectRiskPlanById(riskPlanTask.getPlanId());
        if (riskPlanTask!=null) {
            if (riskPlanTask.getTaskKey().equals("WAIT_START")&&riskPlanTask.getStatus().equals("running")) {
                //修改任务状态
                riskPlanTask.setStatus("completed");
                riskPlanTask.setCompletedTime(new Date());
                int rs=riskPlanTaskMapper.updateRiskPlanTask(riskPlanTask);
                if (rs>-1) {//修改状态成功
                    System.out.println("修改状态成功");
                }
                //创建任务执行状态
                RiskPlanTask riskPlanTask1 = new RiskPlanTask();
                riskPlanTask1.setPlanId(riskPlanTask.getPlanId());
                riskPlanTask1.setApprovalUserId(riskPlan.getLeaderUserId());
                riskPlanTask1.setTaskKey(RiskPlanStatusType.RUNNING.getStatus());
                riskPlanTask1.setTaskName(RiskPlanStatusType.RUNNING.getTitle());
                riskPlanTask1.setStatus("running");
                riskPlanTask1.setStartTime(new Date());
                riskPlanTaskService.insertRiskPlanTask(riskPlanTask1);
            }
        }
        riskPlanInherentList.setUpdateTime(DateUtils.getNowDate());
        return riskPlanInherentListMapper.updateRiskPlanInherentList(riskPlanInherentList);
    }

    /**
     * 批量删除固有风险清单库
     *
     * @param ids 需要删除的固有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanInherentListByIds(Long[] ids) {
        /**
         * 解题思路
         * 1.判断当前任务状态是否待执行状态
         * 2.待执行修改执行状态变为已完成否则不操作
         * 3.改为已完成添加任务执行记录
         */
        RiskPlanInherentList riskPlanInherentList=riskPlanInherentListMapper.selectRiskPlanInherentListById(ids[0]);
        RiskPlanTask riskPlanTask=riskPlanTaskMapper.getLastRiskPlanTaskByPlanId(riskPlanInherentList.getPlanId());
        //计划
        RiskPlan riskPlan = riskPlanMapper.selectRiskPlanById(riskPlanTask.getPlanId());
        if (riskPlanTask!=null) {
            if (riskPlanTask.getTaskKey().equals("WAIT_START")&&riskPlanTask.getStatus().equals("running")) {
                //修改任务状态
                riskPlanTask.setStatus("completed");
                riskPlanTask.setCompletedTime(new Date());
                int rs=riskPlanTaskMapper.updateRiskPlanTask(riskPlanTask);
                if (rs>-1) {//修改状态成功
                    System.out.println("修改状态成功");
                }
                //创建任务执行状态
                RiskPlanTask riskPlanTask1 = new RiskPlanTask();
                riskPlanTask1.setPlanId(riskPlanTask.getPlanId());
                riskPlanTask1.setApprovalUserId(riskPlan.getLeaderUserId());
                riskPlanTask1.setTaskKey(RiskPlanStatusType.RUNNING.getStatus());
                riskPlanTask1.setTaskName(RiskPlanStatusType.RUNNING.getTitle());
                riskPlanTask1.setStatus("running");
                riskPlanTask1.setStartTime(new Date());
                riskPlanTaskService.insertRiskPlanTask(riskPlanTask1);
            }
        }
        return riskPlanInherentListMapper.deleteRiskPlanInherentListByIds(ids);
    }

    /**
     * 删除固有风险清单库信息
     *
     * @param id 固有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanInherentListById(Long id) {
        /**
         * 解题思路
         * 1.判断当前任务状态是否待执行状态
         * 2.待执行修改执行状态变为已完成否则不操作
         * 3.改为已完成添加任务执行记录
         */
        RiskPlanInherentList riskPlanInherentList=riskPlanInherentListMapper.selectRiskPlanInherentListById(id);
        RiskPlanTask riskPlanTask=riskPlanTaskMapper.getLastRiskPlanTaskByPlanId(riskPlanInherentList.getPlanId());
        //计划
        RiskPlan riskPlan = riskPlanMapper.selectRiskPlanById(riskPlanTask.getPlanId());
        if (riskPlanTask!=null) {
            if (riskPlanTask.getTaskKey().equals("WAIT_START")&&riskPlanTask.getStatus().equals("running")) {
                //修改任务状态
                riskPlanTask.setStatus("completed");
                riskPlanTask.setCompletedTime(new Date());
                int rs=riskPlanTaskMapper.updateRiskPlanTask(riskPlanTask);
                if (rs>-1) {//修改状态成功
                    System.out.println("修改状态成功");
                }
                //创建任务执行状态
                RiskPlanTask riskPlanTask1 = new RiskPlanTask();
                riskPlanTask1.setPlanId(riskPlanTask.getPlanId());
                riskPlanTask1.setApprovalUserId(riskPlan.getLeaderUserId());
                riskPlanTask1.setTaskKey(RiskPlanStatusType.RUNNING.getStatus());
                riskPlanTask1.setTaskName(RiskPlanStatusType.RUNNING.getTitle());
                riskPlanTask1.setStatus("running");
                riskPlanTask1.setStartTime(new Date());
                riskPlanTaskService.insertRiskPlanTask(riskPlanTask1);
            }
        }
        return riskPlanInherentListMapper.deleteRiskPlanInherentListById(id);
    }

    @Override
    public List<RiskPlanAppInherentListDto> getInherentListByPlanId(Long planId, Long buildingId, Long floorId, Long roomId) {
        return riskPlanInherentListMapper.getInherentListByPlanId(planId, buildingId, floorId, roomId);
    }

    @Override
    public Integer saveRiskInherentListSaveDto(RiskInherentListSaveDto saveDto) {
        RiskPlanInherentList inherentList = new RiskPlanInherentList();
        BeanUtils.copyProperties(saveDto, inherentList);
        return insertRiskPlanInherentList(inherentList);
    }

    @Override
    public RiskPlanAppInherentListDetailsDto getRiskPlanAppInherentListDetailsDtoByInherentId(Long inherentId) {
        RiskPlanAppInherentListDetailsDto dto = riskPlanInherentListMapper.getRiskPlanAppInherentListDetailsDtoByInherentId(inherentId);

        //风险源照片
        if (!StrUtil.hasEmpty(dto.getPictureFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getPictureFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setPictureFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //工程技术措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresProjectFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresProjectFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresProjectFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //管理措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresAdministrationFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresAdministrationFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresAdministrationFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //应急处置措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresEmergencyFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresEmergencyFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresEmergencyFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        return dto;
    }

    @Override
    public List<RiskPlanAppExistingListDto> getExistingListByInherentId(Long inherentId) {
        return riskPlanInherentListMapper.getExistingListByInherentId(inherentId);
    }
}
