package com.censoft.censoftrongtong.enums;

public enum RiskPlanStatusType {
    /**
     * 创建任务计划
     */
    CREATE_TASK("CREATE_TASK","创建任务计划"),
    /**
     * 任务待执行
     */
    WAIT_START("WAIT_START","任务待执行"),
    /**
     * 执行任务
     */
    RUNNING("RUNNING","执行任务"),
    /**
     * 验收任务
     */
    WAIT_LEADER_APPROVE("WAIT_LEADER_APPROVE","验收任务"),
    /**
     * 审批任务
     */
    WAIT_APPROVE("WAIT_APPROVE","审批任务"),
    /**
     * 项目评估报告
     */
    PROJECT_REPORT("PROJECT_REPORT","项目评估报告"),
    /**
     * 项目完成
     */
    FINISH("FINISH","项目完成"),
    /**
     * 已退回至组长
     */
    WAIT_LEADER_RETURN("WAIT_LEADER_RETURN","已退回至组长"),
    /**
     * 已退回至组员
     */
    WAIT_RETURN("WAIT_RETURN","已退回至组员"),
    /**
     * 已撤销
     */
    REVOKE("REVOKE","已撤销");

    private final String status;

    private final String title;



    RiskPlanStatusType(String status, String title) {
        this.status = status;
        this.title = title;
    }

    public String getStatus() {
        return status;
    }

    public String getTitle() {
        return title;
    }

    public static RiskPlanStatusType getTitleByStatus(String status){
        switch (status){
            case "CREATE_TASK":
                return CREATE_TASK;
            case "WAIT_START":
                return WAIT_START;
            case "RUNNING":
                return RUNNING;
            case "WAIT_LEADER_APPROVE":
                return WAIT_LEADER_APPROVE;
            case "WAIT_APPROVE":
                return WAIT_APPROVE;
            case "PROJECT_REPORT":
                return PROJECT_REPORT;
            case "FINISH":
                return FINISH;
            case "WAIT_LEADER_RETURN":
                return WAIT_LEADER_RETURN;
            case "WAIT_RETURN":
                return WAIT_RETURN;
            case "REVOKE":
                return REVOKE;
        }
        return null;
    }
}
