package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrol;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrolVO;
import com.censoft.censoftrongtong.domain.LedgerProject;
import com.github.yulichang.base.MPJBaseMapper;

import java.util.List;

/**
 * 巡查执行管理Mapper接口
 * 
 * @author baode
 * @date 2023-12-05
 */
public interface CurrentRiskUserPatrolMapper  extends MPJBaseMapper<CurrentRiskUserPatrol>
{
    /**
     * 查询巡查执行管理
     * 
     * @param id 巡查执行管理主键
     * @return 巡查执行管理
     */
    public CurrentRiskUserPatrol selectCurrentRiskUserPatrolById(Long id);

    /**
     * 巡查记录详情
     *
     * @param id 巡查记录主键
     * @return 巡查执行管理
     */
    public CurrentRiskUserPatrolVO selectCurrentRiskUserPatrolDetail(Long id);
    public List<CurrentRiskUserPatrolVO> selectCurrentRiskUserPatrolDetailList(CurrentRiskUserPatrol currentRiskUserPatrol);

    /**
     * 根据用户id获取巡检项目
     * @param userId
     * @return
     */
    public List<LedgerProject> getPatrolProjectList(Long userId);



    /**
     * 查询巡查执行管理列表
     * 
     * @param currentRiskUserPatrol 巡查执行管理
     * @return 巡查执行管理集合
     */
    public List<CurrentRiskUserPatrol> selectCurrentRiskUserPatrolList(CurrentRiskUserPatrol currentRiskUserPatrol);

    /**
     * 新增巡查执行管理
     * 
     * @param currentRiskUserPatrol 巡查执行管理
     * @return 结果
     */
    public int insertCurrentRiskUserPatrol(CurrentRiskUserPatrol currentRiskUserPatrol);

    /**
     * 修改巡查执行管理
     * 
     * @param currentRiskUserPatrol 巡查执行管理
     * @return 结果
     */
    public int updateCurrentRiskUserPatrol(CurrentRiskUserPatrol currentRiskUserPatrol);

    /**
     * 删除巡查执行管理
     * 
     * @param id 巡查执行管理主键
     * @return 结果
     */
    public int deleteCurrentRiskUserPatrolById(Long id);

    /**
     * 批量删除巡查执行管理
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteCurrentRiskUserPatrolByIds(Long[] ids);
}
