package com.censoft.censoftrongtong.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.util.Date;

/**
 * 巡查执行管理对象 current_risk_user_patrol
 * 
 * @author baode
 * @date 2023-12-05
 */
@Data
public class CurrentRiskUserPatrolVO
{

    /**
     * 项目信息
     */

    /** 项目名称 */
    private String projectName;

    /**
     * 现状风险类型
     */
    private String type;
    /**
     * 现状风险信息
     */
    private String level;

    /** 风险因素 */
    private String factor;

    /** 工程技术措施 */
    private String measuresProject;


    /** 管理措施 */
    private String measuresAdministration;


    /** 应急处置措施 */
    private String measuresEmergency;

    /**
     * 巡查信息
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    private Long userId;

    /** 项目 id */

    private Long projectId;

    /** 现状风险岗位 id */

    private Long riskPostId;

    /** 巡查类型 0 日查 1 周查 2 月查 3 季查 4 年查 */
    private Integer patrolType;

    /** 状态 0 未巡查 1 已巡查 */
    private String status;

    /** 开始巡查时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    /** 结束巡查时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date validityTime;


    private String riskPostName;

    private String nickName;
    /** 状态 0 正常 1 异常 */
    private String exceptStatus;
    /**
     * 异常信息
     */
    CurrentRiskDetailAbnormal currentailAbnormal;

}
