package com.censoft.censoftrongtong.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;

import java.util.Date;

/**
 * 巡查执行管理对象 current_risk_user_patrol
 * 
 * @author baode
 * @date 2023-12-05
 */
@Data
public class CurrentRiskUserPatrol extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 用户 id */
    @Excel(name = "用户 id")
    private Long userId;

    /** 项目 id */
    @Excel(name = "项目 id")
    private Long projectId;

    /** 现状风险岗位 id */
    @Excel(name = "现状风险岗位 id")
    private Long riskPostId;

    /** 巡查类型 0 日查 1 周查 2 月查 3 季查 4 年查 */
    @Excel(name = "巡查类型 0 日查 1 周查 2 月查 3 季查 4 年查")
    private Integer patrolType;

    /** 状态 0 未巡查 1 已巡查 */
    @Excel(name = "状态 0 未巡查 1 已巡查")
    private String status;

    /** 开始巡查时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始巡查时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束巡查时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束巡查时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "过期时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date validityTime;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNum;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    private String riskPostName;

    private String nickName;
    /** 状态 0 正常 1 异常 */
    private String exceptStatus;
    /** 项目名称 */
    private String projectName;
}
