package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntityClean;
import com.ruoyi.system.domain.SysUploadFile;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 现状风险巡查异常信息对象 current_risk_detail_abnormal
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
@Data
public class CurrentRiskDetailAbnormal extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 巡查 id */
    @Excel(name = "巡查 id")
    private Long patrolId;

    /** 巡查明细id */
    @Excel(name = "巡查明细id")
    private Long patrolDetailId;

    /**
     *
     */
    @TableField(exist = false)
    private Long buildingId;

    @TableField(exist = false)
    private BigDecimal score;


    /** 巡查内容 */
    @Excel(name = "巡查内容")
    private String riskContent;

    /** 巡查地点 */
    @Excel(name = "巡查地点")
    private String riskLocation;

    /** 异常说明 */
    @Excel(name = "异常说明")
    private String abnormalDesc;

    /** 异常照片 */
    @Excel(name = "异常照片")
    private String abnormalPics;

    /** 评估等级 */
    @Excel(name = "评估等级")
    private String assessmentLevel;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNum;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    /** 文件ids */
    @TableField(exist = false)
    private List<SysUploadFile> files;
}
