package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.LedgerBuilding;
import com.censoft.censoftrongtong.domain.LedgerFloor;
import com.censoft.censoftrongtong.service.ILedgerBuildingService;
import com.censoft.censoftrongtong.service.ILedgerFloorService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 基础数据-楼宇Controller
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@RestController
@RequestMapping("/system/ledger/building")
public class LedgerBuildingController extends BaseController
{
    @Autowired
    private ILedgerBuildingService ledgerBuildingService;

    /**
     * 查询基础数据-楼宇列表
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerBuilding:list')")
    @GetMapping("/list")
    public TableDataInfo list(LedgerBuilding ledgerBuilding)
    {
        startPage();
        if (ledgerBuilding.getDeptId() == null){
            ledgerBuilding.setDeptId(getDeptId());
        }
        List<LedgerBuilding> list = ledgerBuildingService.selectLedgerBuildingList(ledgerBuilding);
        return getDataTable(list);
    }

    /**
     * 导出基础数据-楼宇列表
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerBuilding:export')")
    @Log(title = "基础数据-楼宇", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LedgerBuilding ledgerBuilding)
    {
        if (ledgerBuilding.getDeptId() == null){
            ledgerBuilding.setDeptId(getDeptId());
        }
        List<LedgerBuilding> list = ledgerBuildingService.selectLedgerBuildingList(ledgerBuilding);
        ExcelUtil<LedgerBuilding> util = new ExcelUtil<LedgerBuilding>(LedgerBuilding.class);
        util.exportExcel(response, list, "基础数据-楼宇数据");
    }

    /**
     * 获取基础数据-楼宇详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerBuilding:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ledgerBuildingService.selectLedgerBuildingById(id));
    }

    /**
     * 新增基础数据-楼宇
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerBuilding:add')")
    @Log(title = "基础数据-楼宇", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody LedgerBuilding ledgerBuilding)
    {
        ledgerBuilding.setCreateBy(getUsername());
        return toAjax(ledgerBuildingService.insertLedgerBuilding(ledgerBuilding));
    }

    /**
     * 修改基础数据-楼宇
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerBuilding:edit')")
    @Log(title = "基础数据-楼宇", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody LedgerBuilding ledgerBuilding)
    {
        ledgerBuilding.setUpdateBy(getUsername());
        return toAjax(ledgerBuildingService.updateLedgerBuilding(ledgerBuilding));
    }

    /**
     * 删除基础数据-楼宇
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerBuilding:remove')")
    @Log(title = "基础数据-楼宇", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ledgerBuildingService.deleteLedgerBuildingByIds(ids));
    }


    @Resource
    private ILedgerFloorService ledgerFloorService;

    //批量导入
    @GetMapping("/insert/all")
    public void test(LedgerBuilding ledgerBuilding)
    {
        List<LedgerBuilding> list = ledgerBuildingService.selectLedgerBuildingList(ledgerBuilding);
        for (LedgerBuilding building : list) {
            if (building.getGroundFloor()!=0){
                for (int i = 1; i <= building.getGroundFloor(); i++) {
                    LedgerFloor ledgerFloor = new LedgerFloor();
                    ledgerFloor.setBuildingId(building.getId());
                    ledgerFloor.setName(i+"层");
                    ledgerFloor.setType("地上");
                    ledgerFloorService.insertLedgerFloor(ledgerFloor);
                }
            }
            if (building.getUndergroundFloor()!=0){
                for (int i = 1; i <= building.getUndergroundFloor(); i++) {
                    LedgerFloor ledgerFloor = new LedgerFloor();
                    ledgerFloor.setBuildingId(building.getId());
                    ledgerFloor.setName(-i+"层");
                    ledgerFloor.setType("地下");
                    ledgerFloorService.insertLedgerFloor(ledgerFloor);
                }
            }
        }
        return ;
    }
}
