package com.censoft.censoftrongtong.controller;

import com.censoft.censoftrongtong.domain.CurrentRiskDetailAbnormal;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrolDetail;
import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.service.ICurrentRiskDetailAbnormalService;
import com.censoft.censoftrongtong.service.ICurrentRiskUserPatrolDetailService;
import com.censoft.censoftrongtong.service.IRiskPlanExistingListService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.config.RuoYiConfig;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysUploadFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 现状风险巡查异常信息Controller
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
@RestController
@RequestMapping(value = {"/risk/currentRiskAbnormal", "/app-api/risk/currentRiskAbnormal"})
public class CurrentRiskDetailAbnormalController extends BaseController
{
    @Autowired
    private ICurrentRiskDetailAbnormalService currentRiskDetailAbnormalService;
    @Autowired
        private ICurrentRiskUserPatrolDetailService currentRiskUserPatrolDetailService;

    @Autowired
    private IRiskPlanExistingListService riskPlanExistingListService;
    @Resource
    private ISysUploadFileService uploadFileService;

    /**
     * 服务器地址
     */
    @Value("${ruoyi.serverAddress}")
    private String serverAddress;

    /**
     * 查询现状风险巡查异常信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        startPage();
        List<CurrentRiskDetailAbnormal> list = currentRiskDetailAbnormalService.selectCurrentRiskDetailAbnormalList(currentRiskDetailAbnormal);
        return getDataTable(list);
    }

    /**
     * 导出现状风险巡查异常信息列表
     */
    @Log(title = "现状风险巡查异常信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        List<CurrentRiskDetailAbnormal> list = currentRiskDetailAbnormalService.selectCurrentRiskDetailAbnormalList(currentRiskDetailAbnormal);
        ExcelUtil<CurrentRiskDetailAbnormal> util = new ExcelUtil<CurrentRiskDetailAbnormal>(CurrentRiskDetailAbnormal.class);
        util.exportExcel(response, list, "现状风险巡查异常信息数据");
    }

    /**
     * 获取现状风险巡查异常信息详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(currentRiskDetailAbnormalService.selectCurrentRiskDetailAbnormalById(id));
    }

    /**
     * 新增现状风险巡查异常信息
     */
    @Log(title = "现状风险巡查异常信息", businessType = BusinessType.INSERT)
    @PostMapping("/save1")
    public AjaxResult add1(@RequestBody CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        return toAjax(currentRiskDetailAbnormalService.insertCurrentRiskDetailAbnormal(currentRiskDetailAbnormal));
    }

    /**
     * 新增现状风险巡查异常信息(附件处理)
     */
//    @PreAuthorize("@ss.hasPermi('risk:currentRiskAbnormal:add')")
    @Log(title = "现状风险巡查异常信息", businessType = BusinessType.INSERT)
    @PostMapping("/save")
    @Transactional
    public AjaxResult add( CurrentRiskDetailAbnormal currentRiskDetailAbnormal , @RequestParam(value = "file[]", required = false) MultipartFile[] file)
    {
        CurrentRiskUserPatrolDetail detail= currentRiskUserPatrolDetailService.selectCurrentRiskUserPatrolDetailById(currentRiskDetailAbnormal.getPatrolDetailId());
        if (file != null) {
            String userId = getUserId() + "";
            String pictureFileIds = Arrays.stream(file)
                    .filter(multipartFile -> !multipartFile.isEmpty())
                    .map(multipartFile -> uploadFileService.upload(multipartFile, RuoYiConfig.getUploadPath(), userId, serverAddress).toString())
                    .collect(Collectors.joining(","));
            currentRiskDetailAbnormal.setAbnormalPics(pictureFileIds);
        }
        int rs=currentRiskDetailAbnormalService.insertCurrentRiskDetailAbnormal(currentRiskDetailAbnormal);
        if (rs>0) {
            //重新评估风险 ---修改现状风险分数和等级
            RiskPlanExistingList risk=new RiskPlanExistingList();
            risk.setId(detail.getCurrentRiskId());
            risk.setLevelScore(currentRiskDetailAbnormal.getScore());
            riskPlanExistingListService.updateRiskPlanExistingList(risk);
            riskPlanExistingListService.getRiskLevelByScoreAndUpd(currentRiskDetailAbnormal.getBuildingId(),currentRiskDetailAbnormal.getScore());

            //修改异常状态
            detail.setStatus("1");
            currentRiskUserPatrolDetailService.updateCurrentRiskUserPatrolDetail(detail);
        }
        return toAjax(rs);
    }

    /**
     * 修改现状风险巡查异常信息
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskAbnormal:edit')")
    @Log(title = "现状风险巡查异常信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        return toAjax(currentRiskDetailAbnormalService.updateCurrentRiskDetailAbnormal(currentRiskDetailAbnormal));
    }

    /**
     * 删除现状风险巡查异常信息
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskAbnormal:remove')")
    @Log(title = "现状风险巡查异常信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(currentRiskDetailAbnormalService.deleteCurrentRiskDetailAbnormalByIds(ids));
    }
}
