package com.ruoyi.system.service.impl;

import com.ruoyi.common.utils.file.FileUploadUtils;
import com.ruoyi.system.domain.SysUploadFile;
import com.ruoyi.system.mapper.SysUploadFileMapper;
import com.ruoyi.system.service.ISysUploadFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 文件Service业务层处理
 * 
 * @author hzhou
 * @date 2022-08-18
 */
@Service
public class SysUploadFileServiceImpl implements ISysUploadFileService
{
    @Autowired
    private SysUploadFileMapper sysUploadFileMapper;

    /**
     * 查询文件
     * 
     * @param fileId 文件主键
     * @return 文件
     */
    @Override
    public SysUploadFile selectSysFileByFileId(Long fileId)
    {
        return sysUploadFileMapper.selectSysFileByFileId(fileId);
    }

    /**
     * 查询文件列表
     * 
     * @param sysUploadFile 文件
     * @return 文件
     */
    @Override
    public List<SysUploadFile> selectSysFileList(SysUploadFile sysUploadFile)
    {
        return sysUploadFileMapper.selectSysFileList(sysUploadFile);
    }

    /**
     * 新增文件
     * 
     * @param sysUploadFile 文件
     * @return 结果
     */
    @Override
    public int insertSysFile(SysUploadFile sysUploadFile)
    {
        return sysUploadFileMapper.insertSysFile(sysUploadFile);
    }

    /**
     * 修改文件
     * 
     * @param sysUploadFile 文件
     * @return 结果
     */
    @Override
    public int updateSysFile(SysUploadFile sysUploadFile)
    {
        return sysUploadFileMapper.updateSysFile(sysUploadFile);
    }

    /**
     * 批量删除文件
     * 
     * @param fileIds 需要删除的文件主键
     * @return 结果
     */
    @Override
    public int deleteSysFileByFileIds(Long[] fileIds)
    {
        return sysUploadFileMapper.deleteSysFileByFileIds(fileIds);
    }

    /**
     * 删除文件信息
     * 
     * @param fileId 文件主键
     * @return 结果
     */
    @Override
    public int deleteSysFileByFileId(Long fileId)
    {
        return sysUploadFileMapper.deleteSysFileByFileId(fileId);
    }

    @Override
    public Long upload(MultipartFile file,String filePath,String userName,String url) {
        int result;
        SysUploadFile sysFile = new SysUploadFile();
        try
        {
            // 上传并返回新文件名称
            String fileName = file.getOriginalFilename();
            String newFileName = FileUploadUtils.upload(filePath, file);

            // 正式部署文件上传公网地址
            url = url + newFileName;

            sysFile.setFileName(fileName);
            sysFile.setFilePath(url);
            sysFile.setCreateBy(userName);
            sysFile.setCreateDate(new Date());
            result = insertSysFile(sysFile);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            throw new RuntimeException("上传文件失败..");
        }
        return sysFile.getFileId();
    }

    @Override
    public List<SysUploadFile> selectSysFileByFileIds(List<Long> fileIds) {
        if (fileIds.isEmpty()) return new ArrayList<>();
        return sysUploadFileMapper.selectSysFileByFileIds(fileIds);
    }
}
