package com.censoft.censoftrongtong.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.censoft.censoftrongtong.domain.RiskAssessmentMatrixLevel;
import com.censoft.censoftrongtong.mapper.RiskAssessmentMatrixLevelMapper;
import com.censoft.censoftrongtong.service.IRiskAssessmentMatrixLevelService;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

/**
 * 基础数据-楼层Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskAssessmentMatrixLevelServiceImpl
        extends ServiceImpl<RiskAssessmentMatrixLevelMapper, RiskAssessmentMatrixLevel>
        implements IRiskAssessmentMatrixLevelService {


    @Override
    public RiskAssessmentMatrixLevel getRiskAssessmentMatrixLevelByScore(BigDecimal score) {
        LambdaQueryWrapper<RiskAssessmentMatrixLevel> wrapper = new LambdaQueryWrapper<>();
        wrapper = wrapper.orderByAsc(RiskAssessmentMatrixLevel::getSort);
        List<RiskAssessmentMatrixLevel> list = list(wrapper);

        //逐个匹配
        Optional<RiskAssessmentMatrixLevel> first = list.stream().filter(po -> {
            boolean minFlag = true;
            boolean maxFlag = true;
            if (po.getMin() != null) {
                minFlag = score.compareTo(po.getMin()) >= 0;
            }
            if (po.getMax() != null) {
                maxFlag = score.compareTo(po.getMax()) < 0;
            }
            return minFlag && maxFlag;
        }).findFirst();

        return first.get();
    }
}
