package com.censoft.censoftrongtong.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.domain.dto.RiskInherentListSaveDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppExistingListDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppInherentListDetailsDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppInherentListDto;

import java.util.List;

/**
 * 固有风险清单库Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface IRiskPlanInherentListService extends IService<RiskPlanInherentList>
{

    List<RiskPlanAppInherentListDto> getInherentListByPlanId(Long projectId, Long buildingId, Long floorId, Long roomId);

    Boolean saveRiskInherentListSaveDto(RiskInherentListSaveDto saveDto);

    RiskPlanAppInherentListDetailsDto getRiskPlanAppInherentListDetailsDtoByInherentId(Long inherentId);

    List<RiskPlanAppExistingListDto> getExistingListByInherentId(Long inherentId);
}
