package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.LedgerFloor;
import com.censoft.censoftrongtong.domain.dto.LedgerFloorDto;

import java.util.List;

/**
 * 基础数据-楼层Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface ILedgerFloorService 
{
    /**
     * 查询基础数据-楼层
     * 
     * @param id 基础数据-楼层主键
     * @return 基础数据-楼层
     */
    public LedgerFloor selectLedgerFloorById(Long id);

    /**
     * 查询基础数据-楼层列表
     * 
     * @param ledgerFloor 基础数据-楼层
     * @return 基础数据-楼层集合
     */
    public List<LedgerFloor> selectLedgerFloorList(LedgerFloor ledgerFloor);

    /**
     * 新增基础数据-楼层
     * 
     * @param ledgerFloor 基础数据-楼层
     * @return 结果
     */
    public int insertLedgerFloor(LedgerFloor ledgerFloor);

    /**
     * 修改基础数据-楼层
     * 
     * @param ledgerFloor 基础数据-楼层
     * @return 结果
     */
    public int updateLedgerFloor(LedgerFloor ledgerFloor);

    /**
     * 批量删除基础数据-楼层
     * 
     * @param ids 需要删除的基础数据-楼层主键集合
     * @return 结果
     */
    public int deleteLedgerFloorByIds(Long[] ids);

    /**
     * 删除基础数据-楼层信息
     * 
     * @param id 基础数据-楼层主键
     * @return 结果
     */
    public int deleteLedgerFloorById(Long id);

    List<LedgerFloorDto> getFloorListByBuildingId(Long buildingId);
}
