package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;

/**
 * 评估模型信息对象 evaluation_model_info
 * 
 * @author xjchen
 * @date 2023-08-08
 */
@Data
public class EvaluationModelInfo extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @TableId(type = IdType.AUTO)
    private Long id;

    /** 影响因素 */
    @Excel(name = "影响因素")
    private String influenceFactor;

    /** 影响因子 */
    @Excel(name = "影响因子")
    private String influenceSubFactor;

    /** 排序 */
    @Excel(name = "排序")
    private Integer sortNum;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;


}
