package com.censoft.censoftrongtong.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.censoft.censoftrongtong.mapper.ProjectUserPostMapper;
import com.censoft.censoftrongtong.domain.ProjectUserPost;
import com.censoft.censoftrongtong.service.IProjectUserPostService;
import com.github.yulichang.base.MPJBaseServiceImpl;
/**
 * 项目用户岗位关系Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
@Service
public class ProjectUserPostServiceImpl extends MPJBaseServiceImpl<ProjectUserPostMapper, ProjectUserPost> implements IProjectUserPostService
{
    @Autowired
    private ProjectUserPostMapper projectUserPostMapper;

    /**
     * 查询项目用户岗位关系
     * 
     * @param id 项目用户岗位关系主键
     * @return 项目用户岗位关系
     */
    @Override
    public ProjectUserPost selectProjectUserPostById(Long id)
    {
        return projectUserPostMapper.selectProjectUserPostById(id);
    }

    /**
     * 查询项目用户岗位关系列表
     * 
     * @param projectUserPost 项目用户岗位关系
     * @return 项目用户岗位关系
     */
    @Override
    public List<ProjectUserPost> selectProjectUserPostList(ProjectUserPost projectUserPost)
    {
        return projectUserPostMapper.selectProjectUserPostList(projectUserPost);
    }

    /**
     * 新增项目用户岗位关系
     * 
     * @param projectUserPost 项目用户岗位关系
     * @return 结果
     */
    @Override
    public int insertProjectUserPost(ProjectUserPost projectUserPost)
    {
        return projectUserPostMapper.insertProjectUserPost(projectUserPost);
    }

    /**
     * 修改项目用户岗位关系
     * 
     * @param projectUserPost 项目用户岗位关系
     * @return 结果
     */
    @Override
    public int updateProjectUserPost(ProjectUserPost projectUserPost)
    {
        return projectUserPostMapper.updateProjectUserPost(projectUserPost);
    }

    /**
     * 批量删除项目用户岗位关系
     * 
     * @param ids 需要删除的项目用户岗位关系主键
     * @return 结果
     */
    @Override
    public int deleteProjectUserPostByIds(Long[] ids)
    {
        return projectUserPostMapper.deleteProjectUserPostByIds(ids);
    }

    /**
     * 删除项目用户岗位关系信息
     * 
     * @param id 项目用户岗位关系主键
     * @return 结果
     */
    @Override
    public int deleteProjectUserPostById(Long id)
    {
        return projectUserPostMapper.deleteProjectUserPostById(id);
    }
}
